package com.brackeen.javagamebook.graphics3D;

import java.awt.Graphics2D;
import com.brackeen.javagamebook.math3D.ViewWindow;

/**
    Nakadka rysowana nad scen gry.
*/
public interface Overlay {


    /**
        Aktualizuje t nakadk w oparciu o ilo czasu,
        jaki min od ostatniej aktualizacji.
    */
    public void update(long elapsedTime);

    /**
        Rysuje nakadk na gotowej klatce. Przekazany obiekt
        ViewWindow okrela rozmiary okna obrazu (zwykle jest
        to cay ekran). Rozmiary ekranu mona otrzyma wywo-
        ujc metod g.getDeviceConfiguration().getBounds();
    */
    public void draw(Graphics2D g, ViewWindow viewWindow);


    /**
        Zwraca true, jeli ta nakadka jest wczona (jeli
        powinna by narysowana)
.
    */
    public boolean isEnabled();
}
