package com.brackeen.javagamebook.shooter3D;

import com.brackeen.javagamebook.math3D.*;
import com.brackeen.javagamebook.game.GameObject;

/**
    Klaas Blast, ktra dziedziczy z klasy GameObject, reprezentuje
    pocisk, ktry porusza si w lini prostej przez pi sekund, po
    czym znika. Pociski natychmiast niszcz trafione boty.
*/
public class Blast extends GameObject {

    private static final long DIE_TIME = 5000;
    private static final float SPEED = 1.5f;
    private static final float ROT_SPEED = .008f;

    private MovingTransform3D transform;
    private long aliveTime;

    /**
        Tworzy nowy obiekt klasy Blast z przekazanym obiekte klasy
        PolygonGroup i znormalizowanym wektorem kierunku.
    */
    public Blast(PolygonGroup polygonGroup, Vector3D direction) {
        super(polygonGroup);
        transform = polygonGroup.getTransform();
        Vector3D velocity = transform.getVelocity();
        velocity.setTo(direction);
        velocity.multiply(SPEED);
        transform.setVelocity(velocity);
        //transform.setAngleVelocityX(ROT_SPEED);
        transform.setAngleVelocityY(ROT_SPEED);
        transform.setAngleVelocityZ(ROT_SPEED);
        setState(STATE_ACTIVE);
    }


    public void update(GameObject player, long elapsedTime) {
        aliveTime+=elapsedTime;
        if (aliveTime >= DIE_TIME) {
            setState(STATE_DESTROYED);
        }
        else {
            super.update(player, elapsedTime);
        }
    }


    public boolean isFlying() {
        return true;
    }


    public void notifyObjectCollision(GameObject object) {
        // zniszcz bota i samego siebie
        if (object instanceof Bot) {
            setState(object, STATE_DESTROYED);
            setState(STATE_DESTROYED);
        }
    }


    public void notifyWallCollision() {
        // zatrzymaj ruch pocisku
        transform.getVelocity().setTo(0,0,0);
    }


    public void notifyFloorCollision() {
        notifyWallCollision();
    }


    public void notifyCeilingCollision() {
        notifyWallCollision();
    }
}
