package com.hypefiend.javagamebook.games.rps;

import com.hypefiend.javagamebook.client.*;
import com.hypefiend.javagamebook.common.*;

import java.nio.*;
import java.nio.channels.*;
import java.util.*;
import java.net.*;
import java.io.*;

import org.apache.log4j.*;

/**
 * RPSClient.java
 *
 * @author <a href="mailto:bret@hypefiend.com">bret barker</a>
 * @version 1.0
 */
public class RPSClient extends GameClient {
    protected static Logger log = Logger.getLogger("RPSClient");

    /** referencja do ConsoleEventReader odcztyujcego zdarzenia uytkownika*/
    protected RPSConsoleEventReader consoleReader;

    /**
     * main.
     */
    public static void main(String args[] ) {
    // konfiguracja log4j
    BasicConfigurator.configure();

    if (args.length < 2) {
        System.out.println("uycie: java com.hypefiend.javagamebook.games.rps.RPSClient <host> <nazwa_gracza>\n");
        System.exit(0);
    }

    // uruchomienie klienta
    RPSClient gc = new RPSClient();
    gc.init(args);
    gc.start();
    }

    /** 
     * wywoanie GameClient.init() 
     * i uruchomienie ConsoleEventReader
     */
    public void init(String args[]) {
    super.init(args);
    consoleReader = new RPSConsoleEventReader(this, inQueue, outQueue);
    consoleReader.start();
    }
    
    /** 
     * wyaczenie klienta
     */
    protected void shutdown() {
    consoleReader.shutdown();
    super.shutdown();
    }

    /** 
     * obsuga przychodzcych obiektw GameEvent z EventQueue
     */
    protected void processIncomingEvents() {
    GameEvent inEvent;
    while (inQueue.size() > 0) {
        try {
        inEvent = inQueue.deQueue();

        switch (inEvent.getType()) {
        case GameEventDefault.S_LOGIN_ACK_OK:
            break;
        case GameEventDefault.SB_LOGIN:
            stdOut( "logowanie: " + inEvent.getMessage());
            break;
        case GameEventDefault.SB_LOGOUT:
            stdOut( "wylogowanie: " + inEvent.getMessage());
            break;
        case GameEventDefault.SB_CHAT_MSG:
            stdOut( inEvent.getPlayerId() + ": " + inEvent.getMessage());
            break;
        case GameEventDefault.S_DISCONNECT:
            stdErr( "odaczony od serwera: " + inEvent.getMessage());
            shutdown();
            break;
        case GameEventDefault.S_JOIN_GAME_ACK_OK:
            stdOut( inEvent.getMessage());
            inGame = true;
            break;
        case GameEventDefault.S_JOIN_GAME_ACK_FAIL:
            stdOut( inEvent.getMessage());
            inGame = false;
            break;
        case GameEventDefault.SB_PLAYER_QUIT:
            stdOut( inEvent.getMessage());
            inGame = false;
            break;            
        default:
            stdOut( inEvent.getMessage());
            break;
        }
        }
        catch (InterruptedException ie) {}
    }
    }

    /** 
     * zwraca nazw gry
     */
    public String getGameName() {
    return "RPS";
    }

    /** 
     * metoda factory do tworzenia obiektu GameEvent
     */
    public GameEvent createGameEvent() {
    return new GameEventDefault();
    }
    
    /** 
     * metoda factory do tworzenia obiektw GameEvent logowania
     */
    public GameEvent createLoginEvent() {
    return new GameEventDefault(GameEventDefault.C_LOGIN);
    }
    
    /** 
     * metoda factory do tworzenia obiektw GameEvent odczania
     */
    public GameEvent createDisconnectEvent(String reason) {
    return new GameEventDefault(GameEventDefault.S_DISCONNECT, reason);
    }
    
}
