import javax.sound.midi.*;

import com.brackeen.javagamebook.sound.MidiPlayer;

/**
    Przykad odtwarzania sekwencji MIDI. Na pocztku sekwencja jest odtwarzana
    z wyczon ciek 1. Nastpnie jest odtwarzana z wczon ciek 1.
    cieka 1 w przykadowym pliku MIDI zawiera bbny.
*/
public class MidiTest implements MetaEventListener {

    // cieka w pliku MIDI zawierajca bbny
    private static final int DRUM_TRACK = 1;

    public static void main(String[] args) {
        new MidiTest().run();
    }

    private MidiPlayer player;

    public void run() {

        player = new MidiPlayer();

        // adowanie sekwencji:
        Sequence sequence =
            player.getSequence("../sounds/music.midi");

        // Odtwarzanie sekwencji:
        player.play(sequence, true);

        // Wyczenie bbnw:
        System.out.println("Odtwarzanie (bez bbnw)...");
        Sequencer sequencer = player.getSequencer();
        sequencer.setTrackMute(DRUM_TRACK, true);
        sequencer.addMetaEventListener(this);
    }

    /**
        Metoda jest wywoywana przez system dwikowy po zajciu
        zdarzenia meta. W tym przypadku, gdy otrzymane zostanie
        zdarzenie meta dla koca cieki, wczana jest cieka bbnw.
    */
    public void meta(MetaMessage event) {
        if (event.getType() == MidiPlayer.END_OF_TRACK_MESSAGE) {
            Sequencer sequencer = player.getSequencer();
            if (sequencer.getTrackMute(DRUM_TRACK)) {
                // Wczanie cieki bbnw:
                System.out.println("Wczanie bbnw...");
                sequencer.setTrackMute(DRUM_TRACK, false);
            }
            else {
                // Zamknicie sekwensera i koniec odtwarzania:
                System.out.println("Wyczanie...");
                player.close();
                System.exit(0);
            }
        }
    }
}
