import java.awt.*;
import java.awt.event.KeyListener;
import java.awt.event.KeyEvent;
import java.util.LinkedList;

import com.brackeen.javagamebook.graphics.*;
import com.brackeen.javagamebook.test.GameCore;

/**
    Prosty test klawiatury. Wywietla na ekranie kody 
    nacinitych i zwolnionych klawiszy. 
    Uyteczne do uruchamiania wejcia z klawiatury.
*/
public class KeyTest extends GameCore implements KeyListener {

    public static void main(String[] args) {
        new KeyTest().run();
    }

    private LinkedList messages = new LinkedList();

    public void init() {
        super.init();

        Window window = screen.getFullScreenWindow();

        // Pozwala na przechwycenie nacinicia TAB i innych klawiszy,
        // normalnie wykorzystywanych do przestawiania fokusu.
        window.setFocusTraversalKeysEnabled(false);
        
        // Rejestrowanie tego obiektu jako procesu nasuchu dla okna.
        window.addKeyListener(this);

        addMessage("KeyInputTest. Nacinij Escape, aby zakoczy");
    }


    // Metoda z interfejsu KeyListener:
    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();

        // Zakoczenie programu:
        if (keyCode == KeyEvent.VK_ESCAPE) {
             stop();
        }
        else {
            addMessage("Nacinito: " +
                KeyEvent.getKeyText(keyCode));

            // Upewnij si, e nacinicie klawisza nie zostanie 
            // przetworzone przez inny proces:
            e.consume();
        }
    }

    // Metoda z interfejsu KeyListener:
    public void keyReleased(KeyEvent e) {
        int keyCode = e.getKeyCode();
        addMessage("Zwolniono: " + KeyEvent.getKeyText(keyCode));

            // Upewnij si, e nacinicie klawisza nie zostanie 
            // przetworzone przez inny proces:
        e.consume();
    }


    // Metoda z interfejsu KeyListener:
    public void keyTyped(KeyEvent e) {
        // Jeli wywoana jest po zwolnieniu klawisza  zignoruj j.
        // Upewnij si, e nacinicie klawisza nie zostanie 
        // przetworzone przez inny proces.
        e.consume();
    }


    /**
        Dodaje komunikat do listy komunikatw.
    */
    public synchronized void addMessage(String message) {
        messages.add(message);
        if (messages.size() >= screen.getHeight() / FONT_SIZE) {
            messages.remove(0);
        }
    }


    /**
        Narysowanie listy komunikatw.
    */
    public synchronized void draw(Graphics2D g) {

        Window window = screen.getFullScreenWindow();

        g.setRenderingHint(
            RenderingHints.KEY_TEXT_ANTIALIASING,
            RenderingHints.VALUE_TEXT_ANTIALIAS_ON);

        // Rysowanie ta:
        g.setColor(window.getBackground());
        g.fillRect(0, 0, screen.getWidth(), screen.getHeight());

        // Rysowanie komunikatw:
        g.setColor(window.getForeground());
        int y = FONT_SIZE;
        for (int i=0; i<messages.size(); i++) {
            g.drawString((String)messages.get(i), 5, y);
            y+=FONT_SIZE;
        }
    }
}
