import java.awt.*;
import javax.swing.JFrame;

/**
    Klasa SimpleScreenManager zarzdza inicjalizacj 
    i wywietlaniem penoekranowych trybw graficznych.
*/
public class SimpleScreenManager {

    private GraphicsDevice device;

    /**
        Tworzy nowy obiekt SimpleScreenManager.
    */
    public SimpleScreenManager() {
        GraphicsEnvironment environment =
            GraphicsEnvironment.getLocalGraphicsEnvironment();
        device = environment.getDefaultScreenDevice();
    }

    /**
        Przechodzi w tryb penoekranowy i zmienia tryb graficzny.
    */
    public void setFullScreen(DisplayMode displayMode,
        JFrame window)
    {
        window.setUndecorated(true);
        window.setResizable(false);

        device.setFullScreenWindow(window);
        if (displayMode != null &&
            device.isDisplayChangeSupported())
        {
            try {
                device.setDisplayMode(displayMode);
            }
            catch (IllegalArgumentException ex) {
                // Ignorowanie - niedozwolony tryb dla tego urzdzenia.
            }
        }
    }


    /**
        Zwraca okno wykorzystywane w trybie penoekranowym.
    */
    public Window getFullScreenWindow() {
        return device.getFullScreenWindow();
    }


    /**
        Przywraca pocztkowy tryb wywietlania.
    */
    public void restoreScreen() {
        Window window = device.getFullScreenWindow();
        if (window != null) {
            window.dispose();
        }
        device.setFullScreenWindow(null);
    }
}
