/*
 * Decompiled with CFR 0.152.
 */
package com.brackeen.javagamebook.tilegame;

import com.brackeen.javagamebook.graphics.Animation;
import com.brackeen.javagamebook.graphics.Sprite;
import com.brackeen.javagamebook.tilegame.TileMap;
import com.brackeen.javagamebook.tilegame.TileMapRenderer;
import com.brackeen.javagamebook.tilegame.sprites.Fly;
import com.brackeen.javagamebook.tilegame.sprites.Grub;
import com.brackeen.javagamebook.tilegame.sprites.Player;
import com.brackeen.javagamebook.tilegame.sprites.PowerUp;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.ImageIcon;

public class ResourceManager {
    private ArrayList tiles;
    private int currentMap;
    private GraphicsConfiguration gc;
    private Sprite playerSprite;
    private Sprite musicSprite;
    private Sprite coinSprite;
    private Sprite goalSprite;
    private Sprite grubSprite;
    private Sprite flySprite;

    public ResourceManager(GraphicsConfiguration gc) {
        this.gc = gc;
        this.loadTileImages();
        this.loadCreatureSprites();
        this.loadPowerUpSprites();
    }

    public Image loadImage(String name) {
        String filename = "images/" + name;
        return new ImageIcon(filename).getImage();
    }

    public Image getMirrorImage(Image image) {
        return this.getScaledImage(image, -1.0f, 1.0f);
    }

    public Image getFlippedImage(Image image) {
        return this.getScaledImage(image, 1.0f, -1.0f);
    }

    private Image getScaledImage(Image image, float x, float y) {
        AffineTransform transform = new AffineTransform();
        transform.scale(x, y);
        transform.translate((x - 1.0f) * (float)image.getWidth(null) / 2.0f, (y - 1.0f) * (float)image.getHeight(null) / 2.0f);
        BufferedImage newImage = this.gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g = (Graphics2D)((Image)newImage).getGraphics();
        g.drawImage(image, transform, null);
        g.dispose();
        return newImage;
    }

    public TileMap loadNextMap() {
        TileMap map = null;
        while (map == null) {
            ++this.currentMap;
            try {
                map = this.loadMap("maps/map" + this.currentMap + ".txt");
            }
            catch (IOException ex) {
                if (this.currentMap == 1) {
                    return null;
                }
                this.currentMap = 0;
                map = null;
            }
        }
        return map;
    }

    public TileMap reloadMap() {
        try {
            return this.loadMap("maps/map" + this.currentMap + ".txt");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private TileMap loadMap(String filename) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        int width = 0;
        int height = 0;
        BufferedReader reader = new BufferedReader(new FileReader(filename));
        while (true) {
            String line;
            if ((line = reader.readLine()) == null) break;
            if (line.startsWith("#")) continue;
            lines.add(line);
            width = Math.max(width, line.length());
        }
        reader.close();
        height = lines.size();
        TileMap newMap = new TileMap(width, height);
        for (int y = 0; y < height; ++y) {
            String line = (String)lines.get(y);
            for (int x = 0; x < line.length(); ++x) {
                char ch = line.charAt(x);
                int tile = ch - 65;
                if (tile >= 0 && tile < this.tiles.size()) {
                    newMap.setTile(x, y, (Image)this.tiles.get(tile));
                    continue;
                }
                if (ch == 'o') {
                    this.addSprite(newMap, this.coinSprite, x, y);
                    continue;
                }
                if (ch == '!') {
                    this.addSprite(newMap, this.musicSprite, x, y);
                    continue;
                }
                if (ch == '*') {
                    this.addSprite(newMap, this.goalSprite, x, y);
                    continue;
                }
                if (ch == '1') {
                    this.addSprite(newMap, this.grubSprite, x, y);
                    continue;
                }
                if (ch != '2') continue;
                this.addSprite(newMap, this.flySprite, x, y);
            }
        }
        Sprite player = (Sprite)this.playerSprite.clone();
        player.setX(TileMapRenderer.tilesToPixels(3));
        player.setY(0.0f);
        newMap.setPlayer(player);
        return newMap;
    }

    private void addSprite(TileMap map, Sprite hostSprite, int tileX, int tileY) {
        if (hostSprite != null) {
            Sprite sprite = (Sprite)hostSprite.clone();
            sprite.setX(TileMapRenderer.tilesToPixels(tileX) + (TileMapRenderer.tilesToPixels(1) - sprite.getWidth()) / 2);
            sprite.setY(TileMapRenderer.tilesToPixels(tileY + 1) - sprite.getHeight());
            map.addSprite(sprite);
        }
    }

    public void loadTileImages() {
        this.tiles = new ArrayList();
        char ch = 'A';
        while (true) {
            String name = "tile_" + ch + ".png";
            File file = new File("images/" + name);
            if (!file.exists()) break;
            this.tiles.add(this.loadImage(name));
            ch = (char)(ch + '\u0001');
        }
    }

    public void loadCreatureSprites() {
        Image[][] images;
        images = new Image[][]{{this.loadImage("player1.png"), this.loadImage("player2.png"), this.loadImage("player3.png"), this.loadImage("fly1.png"), this.loadImage("fly2.png"), this.loadImage("fly3.png"), this.loadImage("grub1.png"), this.loadImage("grub2.png")}, new Image[images[0].length], new Image[images[0].length], new Image[images[0].length]};
        for (int i = 0; i < images[0].length; ++i) {
            images[1][i] = this.getMirrorImage(images[0][i]);
            images[2][i] = this.getFlippedImage(images[0][i]);
            images[3][i] = this.getFlippedImage(images[1][i]);
        }
        Animation[] playerAnim = new Animation[4];
        Animation[] flyAnim = new Animation[4];
        Animation[] grubAnim = new Animation[4];
        for (int i = 0; i < 4; ++i) {
            playerAnim[i] = this.createPlayerAnim(images[i][0], images[i][1], images[i][2]);
            flyAnim[i] = this.createFlyAnim(images[i][3], images[i][4], images[i][5]);
            grubAnim[i] = this.createGrubAnim(images[i][6], images[i][7]);
        }
        this.playerSprite = new Player(playerAnim[0], playerAnim[1], playerAnim[2], playerAnim[3]);
        this.flySprite = new Fly(flyAnim[0], flyAnim[1], flyAnim[2], flyAnim[3]);
        this.grubSprite = new Grub(grubAnim[0], grubAnim[1], grubAnim[2], grubAnim[3]);
    }

    private Animation createPlayerAnim(Image player1, Image player2, Image player3) {
        Animation anim = new Animation();
        anim.addFrame(player1, 250L);
        anim.addFrame(player2, 150L);
        anim.addFrame(player1, 150L);
        anim.addFrame(player2, 150L);
        anim.addFrame(player3, 200L);
        anim.addFrame(player2, 150L);
        return anim;
    }

    private Animation createFlyAnim(Image img1, Image img2, Image img3) {
        Animation anim = new Animation();
        anim.addFrame(img1, 50L);
        anim.addFrame(img2, 50L);
        anim.addFrame(img3, 50L);
        anim.addFrame(img2, 50L);
        return anim;
    }

    private Animation createGrubAnim(Image img1, Image img2) {
        Animation anim = new Animation();
        anim.addFrame(img1, 250L);
        anim.addFrame(img2, 250L);
        return anim;
    }

    private void loadPowerUpSprites() {
        Animation anim = new Animation();
        anim.addFrame(this.loadImage("heart1.png"), 150L);
        anim.addFrame(this.loadImage("heart2.png"), 150L);
        anim.addFrame(this.loadImage("heart3.png"), 150L);
        anim.addFrame(this.loadImage("heart2.png"), 150L);
        this.goalSprite = new PowerUp.Goal(anim);
        anim = new Animation();
        anim.addFrame(this.loadImage("star1.png"), 100L);
        anim.addFrame(this.loadImage("star2.png"), 100L);
        anim.addFrame(this.loadImage("star3.png"), 100L);
        anim.addFrame(this.loadImage("star4.png"), 100L);
        this.coinSprite = new PowerUp.Star(anim);
        anim = new Animation();
        anim.addFrame(this.loadImage("music1.png"), 150L);
        anim.addFrame(this.loadImage("music2.png"), 150L);
        anim.addFrame(this.loadImage("music3.png"), 150L);
        anim.addFrame(this.loadImage("music2.png"), 150L);
        this.musicSprite = new PowerUp.Music(anim);
    }
}

