/*
 * Decompiled with CFR 0.152.
 */
package com.brackeen.javagamebook.util;

public class TimeSmoothie {
    protected static final long FRAME_RATE_RECALC_PERIOD = 500L;
    protected static final long MAX_ELAPSED_TIME = 100L;
    protected static final long AVERAGE_PERIOD = 100L;
    protected static final int NUM_SAMPLES_BITS = 6;
    protected static final int NUM_SAMPLES = 64;
    protected static final int NUM_SAMPLES_MASK = 63;
    protected long[] samples = new long[64];
    protected int numSamples = 0;
    protected int firstIndex = 0;
    protected int numFrames = 0;
    protected long startTime;
    protected float frameRate;

    public long getTime(long elapsedTime) {
        this.addSample(elapsedTime);
        return this.getAverage();
    }

    public void addSample(long elapsedTime) {
        ++this.numFrames;
        this.samples[this.firstIndex + this.numSamples & 0x3F] = elapsedTime = Math.min(elapsedTime, 100L);
        if (this.numSamples == this.samples.length) {
            this.firstIndex = this.firstIndex + 1 & 0x3F;
        } else {
            ++this.numSamples;
        }
    }

    public long getAverage() {
        long sum = 0L;
        for (int i = this.numSamples - 1; i >= 0; --i) {
            if ((sum += this.samples[this.firstIndex + i & 0x3F]) < 100L) continue;
            Math.round((double)sum / (double)(this.numSamples - i));
        }
        return Math.round((double)sum / (double)this.numSamples);
    }

    public float getFrameRate() {
        long currTime = System.currentTimeMillis();
        if (currTime > this.startTime + 500L) {
            this.frameRate = (float)this.numFrames * 1000.0f / (float)(currTime - this.startTime);
            this.startTime = currTime;
            this.numFrames = 0;
        }
        return this.frameRate;
    }
}

