/*
 * Decompiled with CFR 0.152.
 */
package com.brackeen.javagamebook.state;

import com.brackeen.javagamebook.input.InputManager;
import com.brackeen.javagamebook.state.GameState;
import com.brackeen.javagamebook.state.ResourceManager;
import java.awt.Graphics2D;
import java.awt.Image;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class GameStateManager {
    public static final String EXIT_GAME = "_ExitGame";
    private Map gameStates;
    private Image defaultImage;
    private GameState currentState;
    private InputManager inputManager;
    private boolean done;

    public GameStateManager(InputManager inputManager, Image defaultImage) {
        this.inputManager = inputManager;
        this.defaultImage = defaultImage;
        this.gameStates = new HashMap();
    }

    public void addState(GameState state) {
        this.gameStates.put(state.getName(), state);
    }

    public Iterator getStates() {
        return this.gameStates.values().iterator();
    }

    public void loadAllResources(ResourceManager resourceManager) {
        Iterator i = this.getStates();
        while (i.hasNext()) {
            GameState gameState = (GameState)i.next();
            gameState.loadResources(resourceManager);
        }
    }

    public boolean isDone() {
        return this.done;
    }

    public void setState(String name) {
        if (this.currentState != null) {
            this.currentState.stop();
        }
        this.inputManager.clearAllMaps();
        if (name == EXIT_GAME) {
            this.done = true;
        } else {
            this.currentState = (GameState)this.gameStates.get(name);
            if (this.currentState != null) {
                this.currentState.start(this.inputManager);
            }
        }
    }

    public void update(long elapsedTime) {
        if (this.currentState == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {}
        } else {
            String nextState = this.currentState.checkForStateChange();
            if (nextState != null) {
                this.setState(nextState);
            } else {
                this.currentState.update(elapsedTime);
            }
        }
    }

    public void draw(Graphics2D g) {
        if (this.currentState != null) {
            this.currentState.draw(g);
        } else {
            g.drawImage(this.defaultImage, 0, 0, null);
        }
    }
}

