/*
 * Decompiled with CFR 0.152.
 */
package com.brackeen.javagamebook.sound;

import com.brackeen.javagamebook.sound.FilteredSoundStream;
import com.brackeen.javagamebook.sound.Sound;
import com.brackeen.javagamebook.sound.SoundFilter;
import com.brackeen.javagamebook.util.LoopingByteInputStream;
import com.brackeen.javagamebook.util.ThreadPool;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

public class SoundManager
extends ThreadPool {
    private AudioFormat playbackFormat;
    private ThreadLocal localLine;
    private ThreadLocal localBuffer;
    private Object pausedLock;
    private boolean paused;
    static /* synthetic */ Class class$javax$sound$sampled$SourceDataLine;

    public SoundManager(AudioFormat playbackFormat) {
        this(playbackFormat, SoundManager.getMaxSimultaneousSounds(playbackFormat));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SoundManager(AudioFormat playbackFormat, int maxSimultaneousSounds) {
        super(Math.min(maxSimultaneousSounds, SoundManager.getMaxSimultaneousSounds(playbackFormat)));
        this.playbackFormat = playbackFormat;
        this.localLine = new ThreadLocal();
        this.localBuffer = new ThreadLocal();
        this.pausedLock = new Object();
        SoundManager soundManager = this;
        synchronized (soundManager) {
            this.notifyAll();
        }
    }

    public static int getMaxSimultaneousSounds(AudioFormat playbackFormat) {
        DataLine.Info lineInfo = new DataLine.Info(class$javax$sound$sampled$SourceDataLine == null ? (class$javax$sound$sampled$SourceDataLine = SoundManager.class$("javax.sound.sampled.SourceDataLine")) : class$javax$sound$sampled$SourceDataLine, playbackFormat);
        Mixer mixer = AudioSystem.getMixer(null);
        return mixer.getMaxLines(lineInfo);
    }

    protected void cleanUp() {
        this.setPaused(false);
        Mixer mixer = AudioSystem.getMixer(null);
        if (mixer.isOpen()) {
            mixer.close();
        }
    }

    public void close() {
        this.cleanUp();
        super.close();
    }

    public void join() {
        this.cleanUp();
        super.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPaused(boolean paused) {
        if (this.paused != paused) {
            Object object = this.pausedLock;
            synchronized (object) {
                this.paused = paused;
                if (!paused) {
                    this.pausedLock.notifyAll();
                }
            }
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    public Sound getSound(String filename) {
        return this.getSound(this.getAudioInputStream(filename));
    }

    public Sound getSound(InputStream is) {
        return this.getSound(this.getAudioInputStream(is));
    }

    public Sound getSound(AudioInputStream audioStream) {
        if (audioStream == null) {
            return null;
        }
        int length = (int)(audioStream.getFrameLength() * (long)audioStream.getFormat().getFrameSize());
        byte[] samples = new byte[length];
        DataInputStream is = new DataInputStream(audioStream);
        try {
            is.readFully(samples);
            is.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return new Sound(samples);
    }

    public AudioInputStream getAudioInputStream(String filename) {
        try {
            return this.getAudioInputStream(new FileInputStream(filename));
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public AudioInputStream getAudioInputStream(InputStream is) {
        try {
            if (!is.markSupported()) {
                is = new BufferedInputStream(is);
            }
            AudioInputStream source = AudioSystem.getAudioInputStream(is);
            return AudioSystem.getAudioInputStream(this.playbackFormat, source);
        }
        catch (UnsupportedAudioFileException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public InputStream play(Sound sound) {
        return this.play(sound, null, false);
    }

    public InputStream play(Sound sound, SoundFilter filter, boolean loop) {
        if (sound != null) {
            ByteArrayInputStream is = loop ? new LoopingByteInputStream(sound.getSamples()) : new ByteArrayInputStream(sound.getSamples());
            return this.play(is, filter);
        }
        return null;
    }

    public InputStream play(InputStream is) {
        return this.play(is, null);
    }

    public InputStream play(InputStream is, SoundFilter filter) {
        if (is != null) {
            if (filter != null) {
                is = new FilteredSoundStream(is, filter);
            }
            this.runTask(new SoundPlayer(is));
        }
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void threadStarted() {
        SourceDataLine line;
        SoundManager soundManager = this;
        synchronized (soundManager) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        int bufferSize = this.playbackFormat.getFrameSize() * Math.round(this.playbackFormat.getSampleRate() / 10.0f);
        DataLine.Info lineInfo = new DataLine.Info(class$javax$sound$sampled$SourceDataLine == null ? (class$javax$sound$sampled$SourceDataLine = SoundManager.class$("javax.sound.sampled.SourceDataLine")) : class$javax$sound$sampled$SourceDataLine, this.playbackFormat);
        try {
            line = (SourceDataLine)AudioSystem.getLine(lineInfo);
            line.open(this.playbackFormat, bufferSize);
        }
        catch (LineUnavailableException ex) {
            Thread.currentThread().interrupt();
            return;
        }
        line.start();
        byte[] buffer = new byte[bufferSize];
        this.localLine.set(line);
        this.localBuffer.set(buffer);
    }

    protected void threadStopped() {
        SourceDataLine line = (SourceDataLine)this.localLine.get();
        if (line != null) {
            line.drain();
            line.close();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class SoundPlayer
    implements Runnable {
        private InputStream source;

        public SoundPlayer(InputStream source) {
            this.source = source;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            SourceDataLine line = (SourceDataLine)SoundManager.this.localLine.get();
            byte[] buffer = (byte[])SoundManager.this.localBuffer.get();
            if (line == null || buffer == null) {
                return;
            }
            try {
                int numBytesRead = 0;
                while (numBytesRead != -1) {
                    Object object = SoundManager.this.pausedLock;
                    synchronized (object) {
                        if (SoundManager.this.paused) {
                            try {
                                SoundManager.this.pausedLock.wait();
                            }
                            catch (InterruptedException ex) {
                                return;
                            }
                        }
                    }
                    numBytesRead = this.source.read(buffer, 0, buffer.length);
                    if (numBytesRead == -1) continue;
                    line.write(buffer, 0, numBytesRead);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

