/*
 * Decompiled with CFR 0.152.
 */
package com.brackeen.javagamebook.tilegame.sprites;

import com.brackeen.javagamebook.graphics.Animation;
import com.brackeen.javagamebook.graphics.Sprite;
import java.lang.reflect.Constructor;

public abstract class Creature
extends Sprite {
    private static final int DIE_TIME = 1000;
    public static final int STATE_NORMAL = 0;
    public static final int STATE_DYING = 1;
    public static final int STATE_DEAD = 2;
    private Animation left;
    private Animation right;
    private Animation deadLeft;
    private Animation deadRight;
    private int state;
    private long stateTime;

    public Creature(Animation left, Animation right, Animation deadLeft, Animation deadRight) {
        super(right);
        this.left = left;
        this.right = right;
        this.deadLeft = deadLeft;
        this.deadRight = deadRight;
        this.state = 0;
    }

    public Object clone() {
        Constructor<?> constructor = this.getClass().getConstructors()[0];
        try {
            return constructor.newInstance((Animation)this.left.clone(), (Animation)this.right.clone(), (Animation)this.deadLeft.clone(), (Animation)this.deadRight.clone());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public float getMaxSpeed() {
        return 0.0f;
    }

    public void wakeUp() {
        if (this.getState() == 0 && this.getVelocityX() == 0.0f) {
            this.setVelocityX(-this.getMaxSpeed());
        }
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        if (this.state != state) {
            this.state = state;
            this.stateTime = 0L;
            if (state == 1) {
                this.setVelocityX(0.0f);
                this.setVelocityY(0.0f);
            }
        }
    }

    public boolean isAlive() {
        return this.state == 0;
    }

    public boolean isFlying() {
        return false;
    }

    public void collideHorizontal() {
        this.setVelocityX(-this.getVelocityX());
    }

    public void collideVertical() {
        this.setVelocityY(0.0f);
    }

    public void update(long elapsedTime) {
        Animation newAnim = this.anim;
        if (this.getVelocityX() < 0.0f) {
            newAnim = this.left;
        } else if (this.getVelocityX() > 0.0f) {
            newAnim = this.right;
        }
        if (this.state == 1 && newAnim == this.left) {
            newAnim = this.deadLeft;
        } else if (this.state == 1 && newAnim == this.right) {
            newAnim = this.deadRight;
        }
        if (this.anim != newAnim) {
            this.anim = newAnim;
            this.anim.start();
        } else {
            this.anim.update(elapsedTime);
        }
        this.stateTime += elapsedTime;
        if (this.state == 1 && this.stateTime >= 1000L) {
            this.setState(2);
        }
    }
}

