/*
 * Decompiled with CFR 0.152.
 */
package com.brackeen.javagamebook.tilegame;

import com.brackeen.javagamebook.graphics.Sprite;
import com.brackeen.javagamebook.input.GameAction;
import com.brackeen.javagamebook.input.InputManager;
import com.brackeen.javagamebook.sound.EchoFilter;
import com.brackeen.javagamebook.sound.MidiPlayer;
import com.brackeen.javagamebook.sound.Sound;
import com.brackeen.javagamebook.sound.SoundManager;
import com.brackeen.javagamebook.state.GameState;
import com.brackeen.javagamebook.state.ResourceManager;
import com.brackeen.javagamebook.tilegame.TileGameResourceManager;
import com.brackeen.javagamebook.tilegame.TileMap;
import com.brackeen.javagamebook.tilegame.TileMapRenderer;
import com.brackeen.javagamebook.tilegame.sprites.Creature;
import com.brackeen.javagamebook.tilegame.sprites.Player;
import com.brackeen.javagamebook.tilegame.sprites.PowerUp;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.Iterator;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;

public class MainGameState
implements GameState {
    private static final int DRUM_TRACK = 1;
    public static final float GRAVITY = 0.002f;
    private SoundManager soundManager;
    private MidiPlayer midiPlayer;
    private TileGameResourceManager resourceManager;
    private int width;
    private int height;
    private Point pointCache = new Point();
    private Sound prizeSound;
    private Sound boopSound;
    private Sequence music;
    private TileMap map;
    private TileMapRenderer renderer;
    private String stateChange;
    private GameAction moveLeft;
    private GameAction moveRight;
    private GameAction jump;
    private GameAction exit;

    public MainGameState(SoundManager soundManager, MidiPlayer midiPlayer, int width, int height) {
        this.soundManager = soundManager;
        this.midiPlayer = midiPlayer;
        this.width = width;
        this.height = height;
        this.moveLeft = new GameAction("moveLeft");
        this.moveRight = new GameAction("moveRight");
        this.jump = new GameAction("jump", 1);
        this.exit = new GameAction("exit", 1);
        this.renderer = new TileMapRenderer();
        this.toggleDrumPlayback();
    }

    public String getName() {
        return "Main";
    }

    public String checkForStateChange() {
        return this.stateChange;
    }

    public void loadResources(ResourceManager resManager) {
        this.resourceManager = (TileGameResourceManager)resManager;
        this.resourceManager.loadResources();
        this.renderer.setBackground(this.resourceManager.loadImage("background.png"));
        this.map = this.resourceManager.loadNextMap();
        this.prizeSound = this.resourceManager.loadSound("sounds/prize.wav");
        this.boopSound = this.resourceManager.loadSound("sounds/boop2.wav");
        this.music = this.resourceManager.loadSequence("sounds/music.midi");
    }

    public void start(InputManager inputManager) {
        inputManager.mapToKey(this.moveLeft, 37);
        inputManager.mapToKey(this.moveRight, 39);
        inputManager.mapToKey(this.jump, 32);
        inputManager.mapToKey(this.jump, 38);
        inputManager.mapToKey(this.exit, 27);
        this.soundManager.setPaused(false);
        this.midiPlayer.setPaused(false);
        this.midiPlayer.play(this.music, true);
        this.toggleDrumPlayback();
    }

    public void stop() {
        this.soundManager.setPaused(true);
        this.midiPlayer.setPaused(true);
    }

    public void draw(Graphics2D g) {
        this.renderer.draw(g, this.map, this.width, this.height);
    }

    public void toggleDrumPlayback() {
        Sequencer sequencer = this.midiPlayer.getSequencer();
        if (sequencer != null) {
            sequencer.setTrackMute(1, !sequencer.getTrackMute(1));
        }
    }

    private void checkInput(long elapsedTime) {
        if (this.exit.isPressed()) {
            this.stateChange = "_ExitGame";
            return;
        }
        Player player = (Player)this.map.getPlayer();
        if (player.isAlive()) {
            float velocityX = 0.0f;
            if (this.moveLeft.isPressed()) {
                velocityX -= player.getMaxSpeed();
            }
            if (this.moveRight.isPressed()) {
                velocityX += player.getMaxSpeed();
            }
            if (this.jump.isPressed()) {
                player.jump(false);
            }
            player.setVelocityX(velocityX);
        }
    }

    public Point getTileCollision(Sprite sprite, float newX, float newY) {
        float fromX = Math.min(sprite.getX(), newX);
        float fromY = Math.min(sprite.getY(), newY);
        float toX = Math.max(sprite.getX(), newX);
        float toY = Math.max(sprite.getY(), newY);
        int fromTileX = TileMapRenderer.pixelsToTiles(fromX);
        int fromTileY = TileMapRenderer.pixelsToTiles(fromY);
        int toTileX = TileMapRenderer.pixelsToTiles(toX + (float)sprite.getWidth() - 1.0f);
        int toTileY = TileMapRenderer.pixelsToTiles(toY + (float)sprite.getHeight() - 1.0f);
        for (int x = fromTileX; x <= toTileX; ++x) {
            for (int y = fromTileY; y <= toTileY; ++y) {
                if (x >= 0 && x < this.map.getWidth() && this.map.getTile(x, y) == null) continue;
                this.pointCache.setLocation(x, y);
                return this.pointCache;
            }
        }
        return null;
    }

    public boolean isCollision(Sprite s1, Sprite s2) {
        if (s1 == s2) {
            return false;
        }
        if (s1 instanceof Creature && !((Creature)s1).isAlive()) {
            return false;
        }
        if (s2 instanceof Creature && !((Creature)s2).isAlive()) {
            return false;
        }
        int s1x = Math.round(s1.getX());
        int s1y = Math.round(s1.getY());
        int s2x = Math.round(s2.getX());
        int s2y = Math.round(s2.getY());
        return s1x < s2x + s2.getWidth() && s2x < s1x + s1.getWidth() && s1y < s2y + s2.getHeight() && s2y < s1y + s1.getHeight();
    }

    public Sprite getSpriteCollision(Sprite sprite) {
        Iterator i = this.map.getSprites();
        while (i.hasNext()) {
            Sprite otherSprite = (Sprite)i.next();
            if (!this.isCollision(sprite, otherSprite)) continue;
            return otherSprite;
        }
        return null;
    }

    public void update(long elapsedTime) {
        Creature player = (Creature)this.map.getPlayer();
        if (player.getState() == 2) {
            this.map = this.resourceManager.reloadMap();
            return;
        }
        this.checkInput(elapsedTime);
        this.updateCreature(player, elapsedTime);
        player.update(elapsedTime);
        Iterator i = this.map.getSprites();
        while (i.hasNext()) {
            Sprite sprite = (Sprite)i.next();
            if (sprite instanceof Creature) {
                Creature creature = (Creature)sprite;
                if (creature.getState() == 2) {
                    i.remove();
                } else {
                    this.updateCreature(creature, elapsedTime);
                }
            }
            sprite.update(elapsedTime);
        }
    }

    private void updateCreature(Creature creature, long elapsedTime) {
        if (!creature.isFlying()) {
            creature.setVelocityY(creature.getVelocityY() + 0.002f * (float)elapsedTime);
        }
        float dx = creature.getVelocityX();
        float oldX = creature.getX();
        float newX = oldX + dx * (float)elapsedTime;
        Point tile = this.getTileCollision(creature, newX, creature.getY());
        if (tile == null) {
            creature.setX(newX);
        } else {
            if (dx > 0.0f) {
                creature.setX(TileMapRenderer.tilesToPixels(tile.x) - creature.getWidth());
            } else if (dx < 0.0f) {
                creature.setX(TileMapRenderer.tilesToPixels(tile.x + 1));
            }
            creature.collideHorizontal();
        }
        if (creature instanceof Player) {
            this.checkPlayerCollision((Player)creature, false);
        }
        float dy = creature.getVelocityY();
        float oldY = creature.getY();
        float newY = oldY + dy * (float)elapsedTime;
        tile = this.getTileCollision(creature, creature.getX(), newY);
        if (tile == null) {
            creature.setY(newY);
        } else {
            if (dy > 0.0f) {
                creature.setY(TileMapRenderer.tilesToPixels(tile.y) - creature.getHeight());
            } else if (dy < 0.0f) {
                creature.setY(TileMapRenderer.tilesToPixels(tile.y + 1));
            }
            creature.collideVertical();
        }
        if (creature instanceof Player) {
            boolean canKill = oldY < creature.getY();
            this.checkPlayerCollision((Player)creature, canKill);
        }
    }

    public void checkPlayerCollision(Player player, boolean canKill) {
        if (!player.isAlive()) {
            return;
        }
        Sprite collisionSprite = this.getSpriteCollision(player);
        if (collisionSprite instanceof PowerUp) {
            this.acquirePowerUp((PowerUp)collisionSprite);
        } else if (collisionSprite instanceof Creature) {
            Creature badguy = (Creature)collisionSprite;
            if (canKill) {
                this.soundManager.play(this.boopSound);
                badguy.setState(1);
                player.setY(badguy.getY() - (float)player.getHeight());
                player.jump(true);
            } else {
                player.setState(1);
            }
        }
    }

    public void acquirePowerUp(PowerUp powerUp) {
        this.map.removeSprite(powerUp);
        if (powerUp instanceof PowerUp.Star) {
            this.soundManager.play(this.prizeSound);
        } else if (powerUp instanceof PowerUp.Music) {
            this.soundManager.play(this.prizeSound);
            this.toggleDrumPlayback();
        } else if (powerUp instanceof PowerUp.Goal) {
            this.soundManager.play(this.prizeSound, new EchoFilter(2000, 0.7f), false);
            this.map = this.resourceManager.loadNextMap();
        }
    }
}

