/*
 * Decompiled with CFR 0.152.
 */
package com.brackeen.javagamebook.test;

import com.brackeen.javagamebook.graphics.ScreenManager;
import java.awt.Color;
import java.awt.DisplayMode;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Window;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public abstract class GameCore {
    protected static final int FONT_SIZE = 24;
    private static final DisplayMode[] POSSIBLE_MODES = new DisplayMode[]{new DisplayMode(800, 600, 16, 0), new DisplayMode(800, 600, 32, 0), new DisplayMode(800, 600, 24, 0), new DisplayMode(640, 480, 16, 0), new DisplayMode(640, 480, 32, 0), new DisplayMode(640, 480, 24, 0), new DisplayMode(1024, 768, 16, 0), new DisplayMode(1024, 768, 32, 0), new DisplayMode(1024, 768, 24, 0)};
    private boolean isRunning;
    protected ScreenManager screen;

    public void stop() {
        this.isRunning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.init();
            this.gameLoop();
        }
        finally {
            this.screen.restoreScreen();
            this.lazilyExit();
        }
    }

    public void lazilyExit() {
        Thread thread = new Thread(){

            public void run() {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.exit(0);
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    public void init() {
        this.screen = new ScreenManager();
        DisplayMode displayMode = this.screen.findFirstCompatibleMode(POSSIBLE_MODES);
        this.screen.setFullScreen(displayMode);
        JFrame window = this.screen.getFullScreenWindow();
        window.setFont(new Font("Dialog", 0, 24));
        ((Window)window).setBackground(Color.blue);
        window.setForeground(Color.white);
        this.isRunning = true;
    }

    public Image loadImage(String fileName) {
        return new ImageIcon(fileName).getImage();
    }

    public void gameLoop() {
        long startTime;
        long currTime = startTime = System.currentTimeMillis();
        while (this.isRunning) {
            long elapsedTime = System.currentTimeMillis() - currTime;
            currTime += elapsedTime;
            this.update(elapsedTime);
            Graphics2D g = this.screen.getGraphics();
            this.draw(g);
            g.dispose();
            this.screen.update();
        }
    }

    public void update(long elapsedTime) {
    }

    public abstract void draw(Graphics2D var1);
}

