/*
 * Decompiled with CFR 0.152.
 */
package com.brackeen.javagamebook.sound;

import com.brackeen.javagamebook.sound.SoundFilter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FilteredSoundStream
extends FilterInputStream {
    private static final int REMAINING_SIZE_UNKNOWN = -1;
    private SoundFilter soundFilter;
    private int remainingSize;

    public FilteredSoundStream(InputStream in, SoundFilter soundFilter) {
        super(in);
        this.soundFilter = soundFilter;
        this.remainingSize = -1;
    }

    public int read(byte[] samples, int offset, int length) throws IOException {
        int bytesRead = super.read(samples, offset, length);
        if (bytesRead > 0) {
            this.soundFilter.filter(samples, offset, bytesRead);
            return bytesRead;
        }
        if (this.remainingSize == -1) {
            this.remainingSize = this.soundFilter.getRemainingSize();
            this.remainingSize = this.remainingSize / 4 * 4;
        }
        if (this.remainingSize > 0) {
            length = Math.min(length, this.remainingSize);
            for (int i = offset; i < offset + length; ++i) {
                samples[i] = 0;
            }
            this.soundFilter.filter(samples, offset, length);
            this.remainingSize -= length;
            return length;
        }
        return -1;
    }
}

