/*
 * Decompiled with CFR 0.152.
 */
package com.brackeen.javagamebook.graphics;

import java.awt.DisplayMode;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JFrame;

public class ScreenManager {
    private GraphicsDevice device;

    public ScreenManager() {
        GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.device = environment.getDefaultScreenDevice();
    }

    public DisplayMode[] getCompatibleDisplayModes() {
        return this.device.getDisplayModes();
    }

    public DisplayMode findFirstCompatibleMode(DisplayMode[] modes) {
        DisplayMode[] goodModes = this.device.getDisplayModes();
        for (int i = 0; i < modes.length; ++i) {
            for (int j = 0; j < goodModes.length; ++j) {
                if (!this.displayModesMatch(modes[i], goodModes[j])) continue;
                return modes[i];
            }
        }
        return null;
    }

    public DisplayMode getCurrentDisplayMode() {
        return this.device.getDisplayMode();
    }

    public boolean displayModesMatch(DisplayMode mode1, DisplayMode mode2) {
        if (mode1.getWidth() != mode2.getWidth() || mode1.getHeight() != mode2.getHeight()) {
            return false;
        }
        if (mode1.getBitDepth() != -1 && mode2.getBitDepth() != -1 && mode1.getBitDepth() != mode2.getBitDepth()) {
            return false;
        }
        return mode1.getRefreshRate() == 0 || mode2.getRefreshRate() == 0 || mode1.getRefreshRate() == mode2.getRefreshRate();
    }

    public void setFullScreen(DisplayMode displayMode) {
        final JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setUndecorated(true);
        frame.setIgnoreRepaint(true);
        frame.setResizable(false);
        this.device.setFullScreenWindow(frame);
        if (displayMode != null && this.device.isDisplayChangeSupported()) {
            try {
                this.device.setDisplayMode(displayMode);
            }
            catch (IllegalArgumentException ex) {
                // empty catch block
            }
            frame.setSize(displayMode.getWidth(), displayMode.getHeight());
        }
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    frame.createBufferStrategy(2);
                }
            });
        }
        catch (InterruptedException ex) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    public Graphics2D getGraphics() {
        Window window = this.device.getFullScreenWindow();
        if (window != null) {
            BufferStrategy strategy = window.getBufferStrategy();
            return (Graphics2D)strategy.getDrawGraphics();
        }
        return null;
    }

    public void update() {
        BufferStrategy strategy;
        Window window = this.device.getFullScreenWindow();
        if (window != null && !(strategy = window.getBufferStrategy()).contentsLost()) {
            strategy.show();
        }
    }

    public JFrame getFullScreenWindow() {
        return (JFrame)this.device.getFullScreenWindow();
    }

    public int getWidth() {
        Window window = this.device.getFullScreenWindow();
        if (window != null) {
            return window.getWidth();
        }
        return 0;
    }

    public int getHeight() {
        Window window = this.device.getFullScreenWindow();
        if (window != null) {
            return window.getHeight();
        }
        return 0;
    }

    public void restoreScreen() {
        Window window = this.device.getFullScreenWindow();
        if (window != null) {
            window.dispose();
        }
        this.device.setFullScreenWindow(null);
    }

    public BufferedImage createCompatibleImage(int w, int h, int transparancy) {
        Window window = this.device.getFullScreenWindow();
        if (window != null) {
            GraphicsConfiguration gc = window.getGraphicsConfiguration();
            return gc.createCompatibleImage(w, h, transparancy);
        }
        return null;
    }
}

