package rozdzial17;


import java.util.concurrent.*;

public class PrzewidywalnyPorzadekWykonywania {
  public static void main(String[] args) throws InterruptedException {
    long startTime = System.currentTimeMillis();
    for (int i = 0; i < 100; i++) {
      PrzewidywalneUsypianie.main(args);
    }
    long endTime = System.currentTimeMillis();
    System.out.println(endTime-startTime);
  }
}

class PrzewidywalneUsypianie {
  
  public static void main (String[] args) {
    ExecutorService wykonawca = Executors.newSingleThreadExecutor();
    wykonawca.execute(() -> uspijPotemWyswietl());
    System.out.println("Z powrotem w metodzie main()");
    wykonawca.shutdown();
  }
  
  private static void uspijPotemWyswietl() {
    try {
      TimeUnit.SECONDS.sleep(2);
    } catch (InterruptedException ex) {
      ex.printStackTrace();
    }
    System.out.println("Wierzchołek stosu!");
  }
}


class SleepWithTimeUnit {
  public static void main (String[] args) throws InterruptedException {
    ExecutorService executor = Executors.newSingleThreadExecutor();
    executor.execute(() -> sleepThenPrint());
    System.out.println("back in main");
    executor.shutdown();
    executor.awaitTermination(2, TimeUnit.SECONDS);
  }

  private static void sleepThenPrint() {
    try {
      TimeUnit.SECONDS.sleep(2);
    } catch (InterruptedException ex) {
      ex.printStackTrace();
    }
    System.out.println("top o’ the stack");
  }
}

class PrzewidywalnyZatrzask {
  public static void main (String[] args) throws InterruptedException {
    ExecutorService wykonawca = Executors.newSingleThreadExecutor();
    CountDownLatch zatrzask = new CountDownLatch(1);
    
    wykonawca.execute(() -> waitForLatchThenPrint(zatrzask));
    
    System.out.println("Z powrotem w metodzie main()");
    zatrzask.countDown();
    wykonawca.shutdown();
    //wykonawca.awaitTermination(2, TimeUnit.SECONDS);
  }

  private static void waitForLatchThenPrint(CountDownLatch zatrzask) {
    try {
      zatrzask.await();
    } catch (InterruptedException ex) {
      ex.printStackTrace();
    }
    System.out.println("Wierzchołek stosu!");
  }
}

