package rozdzial16;

import javax.swing.*;
import java.awt.*;
import java.io.*;
import java.util.ArrayList;

public class KwizGra {
  private ArrayList<KartaKwizowa> tablicaKart;
  private int indeksBiezacejKarty;
  private KartaKwizowa biezacaKarta;
  private JTextArea polePrezentacji;
  private JFrame ramka;
  private JButton przyciskNastepna;
  private boolean czyPrezentowanaOdpowiedz;

  public static void main(String[] args) {
    KwizGra gra = new KwizGra();
    gra.doRoboty();
  }

  public void doRoboty() {
    ramka = new JFrame("Kwiz");
    JPanel panelGlowny = new JPanel();
    Font czcionkaDuza = new Font("sanserif", Font.BOLD, 24);

    polePrezentacji = new JTextArea(10, 20);
    polePrezentacji.setFont(czcionkaDuza);
    polePrezentacji.setLineWrap(true);
    polePrezentacji.setEditable(false);

    JScrollPane przewijanieP = new JScrollPane(polePrezentacji);
    przewijanieP.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
    przewijanieP.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
    panelGlowny.add(przewijanieP);

    przyciskNastepna = new JButton("Pokaż pytanie");
    przyciskNastepna.addActionListener(e -> nastepnaKarta());
    panelGlowny.add(przyciskNastepna);

    JMenuBar pasekMenu = new JMenuBar();
    JMenu menuPlik = new JMenu("Plik");

    JMenuItem opcjaOtworz = new JMenuItem("Otwórz zestaw kart");
    opcjaOtworz.addActionListener(e -> otworz());

    menuPlik.add(opcjaOtworz);
    pasekMenu.add(menuPlik);
    ramka.setJMenuBar(pasekMenu);

    ramka.getContentPane().add(BorderLayout.CENTER, panelGlowny);
    ramka.setSize(500, 430);
    ramka.setVisible(true);
  }

  private void nastepnaKarta() {
    if (czyPrezentowanaOdpowiedz) {
      // pokaż odpowiedź bo użytkownik już widział pytanie
      polePrezentacji.setText(biezacaKarta.getOdpowiedz());
      przyciskNastepna.setText("Następna karta");
      czyPrezentowanaOdpowiedz = false;
    } else {
      // pokaż następne pytanie
      if (indeksBiezacejKarty < tablicaKart.size()) {
        pokazNastepnaKarte();
      } else {
        // nie ma już więcej kart
        polePrezentacji.setText("To była ostatnia karta");
        przyciskNastepna.setEnabled(false);
      }
    }
  }

  private void otworz() {
    JFileChooser dialogWyboruPliku = new JFileChooser();
    dialogWyboruPliku.showOpenDialog(ramka);
    wczytajPlik(dialogWyboruPliku.getSelectedFile());
  }

  private void wczytajPlik(File plik) {
    tablicaKart = new ArrayList<>();
    indeksBiezacejKarty = 0;
    try {
      BufferedReader czytelnik = new BufferedReader(new FileReader(plik));
      String wiersz;
      while ((wiersz = czytelnik.readLine()) != null) {
        utworzKarte(wiersz);
      }
      czytelnik.close();
    } catch (IOException ex) {
      System.out.println("Nie udało się utworzyć tablicy kart: " + ex.getMessage());
    }
    // czas by zacząć - w tym celu wyświetlamy pierwszą kartę
    pokazNastepnaKarte();
  }

  private void utworzKarte(String lineToParse) {
    String[] wynik = lineToParse.split("/");
    KartaKwizowa karta = new KartaKwizowa(wynik[0], wynik[1]);
    tablicaKart.add(karta);
    System.out.println("Utworzono kartę");
  }

  private void pokazNastepnaKarte() {
    biezacaKarta = tablicaKart.get(indeksBiezacejKarty);
    indeksBiezacejKarty++;
    polePrezentacji.setText(biezacaKarta.getPytanie());
    przyciskNastepna.setText("Wyświetl odpowiedź");
    czyPrezentowanaOdpowiedz = true;
  }
}
      



