package rozdzial12;


import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ZagadkowyStrumien {
  public static void main(String[] args) {
    WyszukiwaniePiosenek wyszukiwaniePiosenek = new WyszukiwaniePiosenek();

    wyszukiwaniePiosenek.wyswietlPierwszychPiec();

    wyszukiwaniePiosenek.szukaj("The Beatles");
    wyszukiwaniePiosenek.szukaj("The Beach Boys");
  }
}

class WyszukiwaniePiosenek {
  private final List<Piosenka> piosenki = 
      new DaneSzafyGrajacej.Piosenki().pobierzPiosenki();

  void wyswietlPierwszychPiec() {
    List<String> pierwszychPiec =
          piosenki.stream()
                  .sorted(Comparator.comparingInt(Piosenka::getLiczbaOdtworzen))
                  .map(piosenka -> piosenka.getTytul())
                  .limit(5)
                  .collect(Collectors.toList());
    System.out.println(pierwszychPiec);
  }

  void szukaj(String artysta) {
    Optional<Piosenka> wyniki = 
          piosenki.stream()
                  .filter(piosenka -> piosenka.getArtysta().equals(artysta))
                  .findFirst();
    if (wyniki.isPresent()) {
      System.out.println(wyniki.get().getTytul());
    } else {
      System.out.println("Nie znaleziono piosenek: " + artysta);
    }
  }
}
