package rozdzial16;


import javax.swing.*;
import java.awt.*;
import java.io.*;
import java.util.ArrayList;

public class KartaKwizowaEdytor {
  private ArrayList<KartaKwizowa> listaKart = new ArrayList<>();
  private JTextArea pytanie;
  private JTextArea odpowiedz;
  private JFrame ramka;

  public static void main(String[] args) {
    new KartaKwizowaEdytor().doDziela();
  }

  public void doDziela() {
    ramka = new JFrame("Edytor kart kwizowych");
    JPanel panelGlowny = new JPanel();
    Font czcionkaDuza = new Font("sanserif", Font.BOLD, 24);

    pytanie = tworzObszarTekstowy(czcionkaDuza);
    JScrollPane przewijaniePyt = utworzPrzewijanie(pytanie);

    odpowiedz = tworzObszarTekstowy(czcionkaDuza);
    JScrollPane przewijanieOdp = utworzPrzewijanie(odpowiedz);

    panelGlowny.add(new JLabel("Pytanie:"));
    panelGlowny.add(przewijaniePyt);

    panelGlowny.add(new JLabel("Odpowiedź:"));
    panelGlowny.add(przewijanieOdp);

    JButton przyciskNastepna = new JButton("Następna karta");
    przyciskNastepna.addActionListener(e -> nastepnaKarta());
    panelGlowny.add(przyciskNastepna);

    JMenuBar pasekMenu = new JMenuBar();
    JMenu menuPlik = new JMenu("Plik");

    JMenuItem opcjaNowa = new JMenuItem("Nowa");
    opcjaNowa.addActionListener(e -> czyscWszystko());

    JMenuItem opcjaZapisz = new JMenuItem("Zapisz");
    opcjaZapisz.addActionListener(e -> zapiszKarte());

    menuPlik.add(opcjaNowa);
    menuPlik.add(opcjaZapisz);
    pasekMenu.add(menuPlik);
    ramka.setJMenuBar(pasekMenu);

    ramka.getContentPane().add(BorderLayout.CENTER, panelGlowny);
    ramka.setSize(500, 600);
    ramka.setVisible(true);
  }

  private JScrollPane utworzPrzewijanie(JTextArea obszarTekstowy) {
    JScrollPane przewijanie = new JScrollPane(obszarTekstowy);
    przewijanie.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
    przewijanie.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
    return przewijanie;
  }

  private JTextArea tworzObszarTekstowy(Font czcionka) {
    JTextArea obszarTekstowy = new JTextArea(6, 20);
    obszarTekstowy.setLineWrap(true);
    obszarTekstowy.setWrapStyleWord(true);
    obszarTekstowy.setFont(czcionka);
    return obszarTekstowy;
  }

  private void nastepnaKarta() {
    KartaKwizowa karta = new KartaKwizowa(pytanie.getText(), odpowiedz.getText());
    listaKart.add(karta);
    czyscKarte();
  }

  private void zapiszKarte() {
    KartaKwizowa karta = new KartaKwizowa(pytanie.getText(), odpowiedz.getText());
    listaKart.add(karta);

    JFileChooser zapisPlikuDlg = new JFileChooser();
    zapisPlikuDlg.showSaveDialog(ramka);
    zapiszPlik(zapisPlikuDlg.getSelectedFile());
  }

  private void czyscWszystko() {
    listaKart.clear();
    czyscKarte();
  }

  private void czyscKarte() {
    pytanie.setText("");
    odpowiedz.setText("");
    pytanie.requestFocus();
  }

  private void zapiszPlik(File plik) {
    try {
      BufferedWriter pisarz = new BufferedWriter(new FileWriter(plik));
      for (KartaKwizowa karta : listaKart) {
        pisarz.write(karta.getPytanie() + "/");
        pisarz.write(karta.getOdpowiedz() + "\n");
      }
      pisarz.close();
    } catch (IOException ex) {
      System.out.println("Nie udało się zapisać pliku kart: " + ex.getMessage());
    }
  }
}
