package rozdzial18.cwiczenie;



import java.util.*;
import java.util.concurrent.*;

public class ZapisZDwochWatkow {
  public static void main(String[] args) {
    ExecutorService pulaWatkow = Executors.newFixedThreadPool(2);
    Dane dane = new Dane();
    pulaWatkow.execute(() -> dodajLitereDoDanych('a', dane));
    pulaWatkow.execute(() -> dodajLitereDoDanych('A', dane));
    pulaWatkow.shutdown();
  }

  private static void dodajLitereDoDanych(char litera, Dane dane) {
    for (int i = 0; i < 26; i++) {
      dane.dodajLitere(litera++);
      try {
        Thread.sleep(50);
      } catch (InterruptedException ignored) {}
    }
    System.out.println(Thread.currentThread().getName() + dane.getLitery());
    System.out.println(Thread.currentThread().getName()
                               + " liczba liter = " + dane.getLitery().size());
  }
}

final class Dane {
  private final List<String> litery = new ArrayList<>();

  public List<String> getLitery() {return litery;}

  public void dodajLitere(char litera) {
    litery.add(String.valueOf(litera));
  }
}
