package rozdzial17;


import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;


public class MojeZadanie implements Runnable {

  public void run() {
    doDziela();
  }

  public void doDziela() {
    kolejnaRobota();
  }

  public void kolejnaRobota() {
    System.out.println(Thread.currentThread().getName() + ": Wierzchołek stosu!");
    Thread.dumpStack();
  }
}

class TesterUruchamiania {
  public static void main(String[] args) {
    MojeZadanie zadanie = new MojeZadanie();
    zadanie.run();

    System.out.println(Thread.currentThread().getName() +
                       ": Z powrotem w metodzie main()");
    Thread.dumpStack();
  }
}

class TesterWatkow {
  public static void main(String[] args) {
    Runnable zadanieWatku = new MojeZadanie();
    Thread mojWatek = new Thread(zadanieWatku);

    mojWatek.start();

    System.out.println(Thread.currentThread().getName() +
                       ": Z powrotem w metodzie main()");
    Thread.dumpStack();
  }
}

class TesterWykonawcy {
  public static void main(String[] args) {
    Runnable zadanie = new MojeZadanie();
    ExecutorService wykonawca = Executors.newSingleThreadExecutor();
    wykonawca.execute(zadanie);

    System.out.println(Thread.currentThread().getName() +
                       ": Z powrotem w metodzie main()");
    Thread.dumpStack();
    wykonawca.shutdown();
  }
}

class NarzedziaStosu {
  static String getCurrentStack() {
    StringBuffer stack = new StringBuffer();
    StackWalker.getInstance()
               .forEach(stackFrame -> stack.append(stackFrame.toString()).append("\n"));
    return stack.toString();
  }
}
