package rozdzial12;


import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class LimityWStrumieniach {

  public static void main(String[] args) {
    przykladyStrumieni();
    //limitZKoncowymZliczeniem();
    //limitZwracajacyWynikiJakoListe();
    //limitWynikiJakoLista();
    //laczenieOperacjWPotok();
    //sortowanieBezUwzglednianiaWielkosci();
    //filtrowanie();
    //wyświetlanieKolekcjiPoZmianach();
    //nieMoznaUzywacWielokrotnie();
  }

  static void przykladyStrumieni() {
    List<String> lancuchy = List.of("Ja", "jestem", "wzorcową", "Listą", "łańcuchów", "znaków");
    Stream<String> strumien = lancuchy.stream();
    Stream<String> strumienZLimitem = strumien.limit(4);
    System.out.println("limit = " + strumienZLimitem);
  }

  static void limitZKoncowymZliczeniem() {
    List<String> lancuchy = List.of("Ja", "jestem", "wzorcową", "Listą", "łańcuchów", "znaków");

    Stream<String> strumien = lancuchy.stream();
    Stream<String> strumienZLimitem = strumien.limit(4);
    long wynik = strumienZLimitem.count();
    System.out.println("wynik = " + wynik);
  }

  static void limitZwracajacyWynikiJakoListe() {
    List<String> lancuchy = List.of("Ja", "jestem", "wzorcową", "Listą", "łańcuchów", "znaków");

    Stream<String> stream = lancuchy.stream();
    Stream<String> strumienZLimitem = stream.limit(4);
    List<String> wynik = strumienZLimitem.collect(Collectors.toList());
    System.out.println("wynik = " + wynik);
  }

  static void limitWynikiJakoLista() {
    List<String> lancuchy = List.of("Ja", "jestem", "wzorcową", "Listą", "łańcuchów", "znaków");

    List<String> wynik = lancuchy.stream()
                                 .limit(4)
                                 .collect(Collectors.toList());
    System.out.println("wynik = " + wynik);
  }

  static void laczenieOperacjWPotok() {
    List<String> lancuchy = List.of("Ja", "jestem", "wzorcową", "Listą", "łańcuchów", "znaków");

    List<String> wynik = lancuchy.stream()
                                 .sorted()
                                 .limit(4)
                                 .collect(Collectors.toList());
    System.out.println("wynik = " + wynik);

    List<String> wynik2 = lancuchy.stream()
                                  .sorted()
                                  .skip(2)
                                  .limit(4)
                                  .collect(Collectors.toList());
    //System.out.println("wynik = " + wynik2);
  }

  static void sortowanieBezUwzglednianiaWielkosci() {
    List<String> lancuchy = List.of("Ja", "jestem", "wzorcową", "Listą", "łańcuchów", "znaków");

    List<String> wynik = lancuchy.stream()
                                 .sorted((s1, s2) -> s1.compareToIgnoreCase(s2))
                                 .limit(4)
                                 .collect(Collectors.toList());
    //System.out.println("wynik = " + wynik);
    
    List<String> wynik2 = lancuchy.stream()
                                 .sorted((s1, s2) -> s1.compareToIgnoreCase(s2))
                                 .skip(2)
                                 .limit(4)
                                 .collect(Collectors.toList());
    System.out.println("wynik = " + wynik2);
  }

  static void filtrowanie() {
    List<String> lancuchy = List.of("Ja", "jestem", "wzorcową", "Listą", "łańcuchów", "znaków");

    List<String> wynik = lancuchy.stream()
                                 .filter(s -> s.length() < 4)
                                 .collect(Collectors.toList());
    System.out.println("wynik = " + wynik);
  }

  static void wyświetlanieKolekcjiPoZmianach() {
    List<String> lancuchy = List.of("Ja", "jestem", "wzorcową", "Listą", "łańcuchów", "znaków");

    List<String> wynik = lancuchy.stream()
                                  .limit(4)
                                  .collect(Collectors.toList());
    System.out.println("lancuchy = " + lancuchy);
    System.out.println("wynik = " + wynik);
  }


  static void nieMoznaUzywacWielokrotnie() {
    List<String> lancuchy = List.of("Ja", "jestem", "wzorcową", "Listą", "łańcuchów", "znaków");

    Stream<String> limit = lancuchy.stream()
                                  .limit(4);
    List<String> wynik = limit.collect(Collectors.toList());
    List<String> wynik2 = limit.collect(Collectors.toList());
  }

}

