//package dodatekA;

import javax.sound.midi.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
import java.io.*;
import java.net.Socket;
import java.util.*;
import java.util.concurrent.*;

import static javax.sound.midi.ShortMessage.*;

public class MuzMachinaKoncowa {
  private JList<String> listaOtrzymanych;
  private JTextArea komunikatUzytkownika;
  private ArrayList<JCheckBox> listaPolWyboru;

  private Vector<String> wektorLista = new Vector<>();
  private HashMap<String, boolean[]> mapaOdebranychKompozycji = new HashMap<>();

  private String uzytkownik;
  private int nastepnyNum;

  private ObjectOutputStream wyj;
  private ObjectInputStream wej;

  private Sequencer sekwenser;
  private Sequence sekwencja;
  private Track sciezka;

  String[] nazwyInstrumentow = {"Bass Drum", "Closed Hi-Hat",
          "Open Hi-Hat", "Acoustic Snare", "Crash Cymbal", "Hand Clap",
          "High Tom", "Hi Bongo", "Maracas", "Whistle", "Low Conga",
          "Cowbell", "Vibraslap", "Low-mid Tom", "High Agogo",
          "Open Hi Conga"};
  int[] instrumenty = {35, 42, 46, 38, 49, 39, 50, 60, 70, 72, 64, 56, 58, 47, 67, 63};

  public static void main(String[] args) {
    new MuzMachinaKoncowa().inicjalizacajAplikacji(args[0]);  // args[0] musi zawierać nazwę użytkownika
  }

  public void inicjalizacajAplikacji(String imie) {
    uzytkownik = imie;
    // Otwieramy połączenie z serwerem
    try {
      Socket gniazdo = new Socket("127.0.0.1", 4242);
      wyj = new ObjectOutputStream(gniazdo.getOutputStream());
      wej = new ObjectInputStream(gniazdo.getInputStream());
      ExecutorService wykonawca = Executors.newSingleThreadExecutor();
      wykonawca.submit(new CzytelnikZdalnychDanych());
    } catch (Exception ex) {
      System.out.println("Nie można nawiązać połączenia - będziesz grał samemu.");
    }
    konfigurujMidi();
    tworzGUI();
  }

  public void tworzGUI() {
    JFrame ramkaGlowna = new JFrame("MuzMachina");
    ramkaGlowna.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    BorderLayout uklad = new BorderLayout();
    JPanel panelTla = new JPanel(uklad);
    panelTla.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));

    Box obszarPrzyciskow = new Box(BoxLayout.Y_AXIS);
    JButton start = new JButton("Start");
    start.addActionListener(e -> utworzSciezkeIOdtworz());
    obszarPrzyciskow.add(start);

    JButton stop = new JButton("Stop");
    stop.addActionListener(e -> sekwenser.stop());
    obszarPrzyciskow.add(stop);

    JButton tempoSzb = new JButton("Szybciej");
    tempoSzb.addActionListener(e -> zmienTempo(1.03f));
    obszarPrzyciskow.add(tempoSzb);

    JButton tempoWol = new JButton("Wolniej");
    tempoWol.addActionListener(e -> zmienTempo(0.97f));
    obszarPrzyciskow.add(tempoWol);

    JButton wyslij = new JButton("Wyślij");
    wyslij.addActionListener(e -> wyslijWiadomoscISciezki());
    obszarPrzyciskow.add(wyslij);

    komunikatUzytkownika = new JTextArea();
    komunikatUzytkownika.setLineWrap(true);
    komunikatUzytkownika.setWrapStyleWord(true);
    JScrollPane przewijanieKomunikatu = new JScrollPane(komunikatUzytkownika);
    obszarPrzyciskow.add(przewijanieKomunikatu);

    listaOtrzymanych = new JList<>();
    listaOtrzymanych.addListSelectionListener(new WyborZListyListener());
    listaOtrzymanych.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    JScrollPane lista = new JScrollPane(listaOtrzymanych);
    obszarPrzyciskow.add(lista);
    listaOtrzymanych.setListData(wektorLista); // Na początku nie ma danych

    Box obszarNazw = new Box(BoxLayout.Y_AXIS);
    for (String instrumentNazwa : nazwyInstrumentow) {
      JLabel instrumentEtykieta = new JLabel(instrumentNazwa);
      instrumentEtykieta.setBorder(BorderFactory.createEmptyBorder(4, 1, 4, 1));
      obszarNazw.add(instrumentEtykieta);
    }

    panelTla.add(BorderLayout.EAST, obszarPrzyciskow);
    panelTla.add(BorderLayout.WEST, obszarNazw);

    ramkaGlowna.getContentPane().add(panelTla);
    GridLayout siatkaPolWyboru = new GridLayout(16, 16);
    siatkaPolWyboru.setVgap(1);
    siatkaPolWyboru.setHgap(2);

    JPanel panelGlowny = new JPanel(siatkaPolWyboru);
    panelTla.add(BorderLayout.CENTER, panelGlowny);

    listaPolWyboru = new ArrayList<>();
    for (int i = 0; i < 256; i++) {
      JCheckBox c = new JCheckBox();
      c.setSelected(false);
      listaPolWyboru.add(c);
      panelGlowny.add(c);
    }

    ramkaGlowna.setBounds(50, 50, 300, 300);
    ramkaGlowna.pack();
    ramkaGlowna.setVisible(true);
  }

  private void konfigurujMidi() {
    try {
      sekwenser = MidiSystem.getSequencer();
      sekwenser.open();
      sekwencja = new Sequence(Sequence.PPQ, 4);
      sciezka = sekwencja.createTrack();
      sekwenser.setTempoInBPM(120);
    } catch (Exception ex) {
      ex.printStackTrace();
    }
  }

  private void utworzSciezkeIOdtworz() {
    ArrayList<Integer> listaSciezek; // Tu będą przechowywane instrumenty ścieżki
    sekwencja.deleteTrack(sciezka);
    sciezka = sekwencja.createTrack();
    for (int i = 0; i < 16; i++) {
      listaSciezek = new ArrayList<>();
      int klucz = instrumenty[i];
      for (int j = 0; j < 16; j++) {
        JCheckBox jc = listaPolWyboru.get(j + (16 * i));
        if (jc.isSelected()) {
          listaSciezek.add(klucz);
        } else {
          listaSciezek.add(null);  // ponieważ ten element powinien być pusty
        }
      }
      utworzSciezki(listaSciezek);
      sciezka.add(tworzZdarzenie(CONTROL_CHANGE, 1, 127, 0, 16));
    }
    sciezka.add(tworzZdarzenie(PROGRAM_CHANGE, 9, 1, 0, 15)); // Zawsze przechodzimy wszystkie 16 taktów
    try {
      sekwenser.setSequence(sekwencja);
      sekwenser.setLoopCount(sekwenser.LOOP_CONTINUOUSLY);
      sekwenser.setTempoInBPM(120);
      sekwenser.start();
    } catch (Exception ex) {
      ex.printStackTrace();
    }
  }

  private void zmienTempo(float mnoznikTempa) {
    float wspolczynikTempa = sekwenser.getTempoFactor();
    sekwenser.setTempoFactor(wspolczynikTempa * mnoznikTempa);
  }

  private void wyslijWiadomoscISciezki() {
    boolean[] stanPolaWyboru = new boolean[256];
    for (int i = 0; i < 256; i++) {
      JCheckBox poleWyboru = listaPolWyboru.get(i);
      if (poleWyboru.isSelected()) {
        stanPolaWyboru[i] = true;
      }
    }
    try {
      wyj.writeObject(uzytkownik + nastepnyNum++ + ": " + komunikatUzytkownika.getText());
      wyj.writeObject(stanPolaWyboru);
    } catch (IOException ex) {
      System.out.println("Bardzo mi przykro! Nie udało się wysłać danych na serwer.");
      ex.printStackTrace();
    }
    komunikatUzytkownika.setText("");
  }

  public class WyborZListyListener implements ListSelectionListener {
    public void valueChanged(ListSelectionEvent lse) {
      if (!lse.getValueIsAdjusting()) {
        String zaznaczony = listaOtrzymanych.getSelectedValue();
        if (zaznaczony != null) {
          // Teraz przechodzimy do mapy i zmieniamy sekwencję
          boolean[] zaznaczonyStan = mapaOdebranychKompozycji.get(zaznaczony);
          modyfikujSekwencje(zaznaczonyStan);
          sekwenser.stop();
          utworzSciezkeIOdtworz();
        }
      }
    }
  }

  private void modyfikujSekwencje(boolean[] stanPolaWyboru) {
    for (int i = 0; i < 256; i++) {
      JCheckBox poleWyboru = listaPolWyboru.get(i);
      poleWyboru.setSelected(stanPolaWyboru[i]);
    }
  }

  public void utworzSciezki(ArrayList<Integer> list) {
    for (int i = 0; i < list.size(); i++) {
      Integer kluczInstrumentu = list.get(i);
      if (kluczInstrumentu != null) {
        sciezka.add(tworzZdarzenie(NOTE_ON, 9, kluczInstrumentu, 100, i));
        sciezka.add(tworzZdarzenie(NOTE_OFF, 9, kluczInstrumentu, 100, i + 1));
      }
    }
  }

  public static MidiEvent tworzZdarzenie(int plc, int kanal, int jeden, int dwa, int takt) {
    MidiEvent zdarzenie = null;
    try {
      ShortMessage a = new ShortMessage();
      a.setMessage(plc, kanal, jeden, dwa);
      zdarzenie = new MidiEvent(a, takt);
    } catch (Exception ex) {
      ex.printStackTrace();
    }
    return zdarzenie;
  }

  public class CzytelnikZdalnychDanych implements Runnable {
    public void run() {
      try {
        Object obj;
        while ((obj = wej.readObject()) != null) {
          System.out.println("pobrano obiekt z serwera");
          System.out.println(obj.getClass());
          String nazwaDoWyswietlenia = (String) obj;
          boolean[] stanPolaWyboru = (boolean[]) wej.readObject();
          mapaOdebranychKompozycji.put(nazwaDoWyswietlenia, stanPolaWyboru);
          wektorLista.add(nazwaDoWyswietlenia);
          listaOtrzymanych.setListData(wektorLista);
        }
      } catch (IOException | ClassNotFoundException ex) {
        ex.printStackTrace();
      }
    }
  }

}
