/*

Java. Programowanie, bibliteki open-source i pomysy na nowe projekty
Wydawnictwo Helion, 2006


Example code from Wicked Cool Java (No Starch Press)
Copyright (C) 2005 Brian D. Eubanks

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

Note: The LGPL licence can be found online at http://www.gnu.org

*/

package com.wickedcooljava.xml;

import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.HTMLWriter;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;

/**
 * Klasa ta pokazuje uycie DOM4J do wczytania danych z dokumentu XML 
 * i do stworzenia dokumentu HTML na ich podstawie.
 */
public class DOM4JPurchaseOrderHTML {
    
    public static void main(String[] args)
    throws DocumentException, IOException {
        // Wczytaj dokument wejciowy (zamwienie)
        String url = "C:/projects/wcj3/purchaseOrder.xml";
        SAXReader reader = new SAXReader();
        Document po = reader.read(url);
        // Utwrz obiekt wyjciowego dokumentu HTML
        Document htmlDoc = DocumentHelper.createDocument();
        // Dodaj deklaracj DOCTYPE w celu otrzymania poprawnego dokumentu XHTML
        htmlDoc.addDocType("html", "-//W3C//DTD XHTML 1.0 Strict//EN", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd");
        // Dodaj tytu z identyfikatorem nabywcy
        String buyerID = po.valueOf("/Order/BuyersID");
        String title = "Purchase Order #" + buyerID;
        // Utwrz element gwny dokumentu HTML i dodaj tytu
        Element html = htmlDoc.addElement("html");
        html.addElement("head").addElement("title").setText(title);
        // Utwrz znaczniki body i h1
        Element body = html.addElement("body");
        body.addElement("h1").addText(title);
        // Utwrz tabel z obramowaniem
        Element table = body.addElement("table").addAttribute("style", "border-width:1px");
        // Utwrz nagwek
        Element header = table.addElement("tr");
        header.addElement("th").addText("Ilo");
        header.addElement("th").addText("Opis");
        header.addElement("th").addText("Cena");
        header.addElement("th").addText("Warto");
        // Pobierz list elementw zamwienia
        List items = po.selectNodes("/Order/OrderLine");
        Iterator iter = items.iterator();
        while (iter.hasNext()) {
            Element item = (Element) iter.next();
            // Dodaj rzd tabeli
            Element row = table.addElement("tr");
            // Dodaj komrk zawierajc ilo
            row.addElement("td").addText(item.valueOf("LineItem/Quantity"))
            .addAttribute("style", "text-align:right");
            // Dodaj komrk zawierajc opis
            row.addElement("td").addText(item.valueOf("LineItem/Item/Description"));
            // Dodaj komrk zawierajc cen
            String priceAmount = item.valueOf("LineItem/Item/BasePrice/PriceAmount");
            row.addElement("td").addText(priceAmount).addAttribute("style", "text-align:right");
            // Dodaj komrk zawierajc warto
            row.addElement("td").addText(item.valueOf("LineItem/LineExtensionAmount"))
            .addAttribute("style", "text-align:right");
        }
        // Utwrz wiersz podsumowania
        Element totalRow = table.addElement("tr");
        totalRow.addElement("th").addAttribute("colspan", "3").addText("Razem");
        String total = po.valueOf("/Order/LineExtensionTotalAmount");
        totalRow.addElement("th").addText(total);
        // Zapisz dokument do pliku
        // Uywamy opcji "pretty printing" w celu utworzenia adnie sformatowanego pliku
        // Bez tego dokument byby pozbawiony wci
        OutputFormat format = OutputFormat.createPrettyPrint();
        FileWriter file = new FileWriter("order.html");
        HTMLWriter writer = new HTMLWriter(file, format);
        writer.write(htmlDoc);
        writer.close();
    }
}
