/*

Java. Programowanie, bibliteki open-source i pomysy na nowe projekty
Wydawnictwo Helion, 2006


Example code from Wicked Cool Java (No Starch Press)
Copyright (C) 2005 Brian D. Eubanks

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

Note: The LGPL licence can be found online at http://www.gnu.org

*/

package com.wickedcooljava.graphics;

import java.io.File;
import java.io.IOException;

import javax.swing.JFrame;

import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.gvt.GVTTreeRendererAdapter;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.svg.GVTTreeBuilderAdapter;
import org.apache.batik.swing.svg.GVTTreeBuilderEvent;
import org.apache.batik.swing.svg.SVGDocumentLoaderAdapter;
import org.apache.batik.swing.svg.SVGDocumentLoaderEvent;

/**
 * Wywietlanie plikw SVG uywajc Batik.
 */
public class BatikDisplay {

	public static void main(String[] args) 
	throws IOException {

        //C:/projects/batik-1.5.1/samples/sizeOfSun.svg
        //File file = new File("C:/projects/batik-1.5.1/samples/sizeOfSun.svg");
        File file = new File("test.svg");
        String url = file.toURL().toString();
        System.out.println(url);
        JSVGCanvas canvas = new JSVGCanvas();
        canvas.setEnableImageZoomInteractor(true);
        canvas.setSize(500,500);
        // dodaje nasuchy do JSVGCanvas
        canvas.addSVGDocumentLoaderListener(new SVGDocumentLoaderAdapter() {
            public void documentLoadingStarted(SVGDocumentLoaderEvent e) {
            	System.out.println("adowanie dokumentu...");
            }
            public void documentLoadingCompleted(SVGDocumentLoaderEvent e) {
            	System.out.println("Dokument zaadowany.");
            }
        });
        canvas.addGVTTreeBuilderListener(new GVTTreeBuilderAdapter() {
            public void gvtBuildStarted(GVTTreeBuilderEvent e) {
                System.out.println("Budowanie rozpoczte...");
            }
            public void gvtBuildCompleted(GVTTreeBuilderEvent e) {
            	System.out.println("Budowanie zakoczone.");
            }
        });
        canvas.addGVTTreeRendererListener(new GVTTreeRendererAdapter() {
            public void gvtRenderingPrepare(GVTTreeRendererEvent e) {
            	System.out.println("Rysowanie rozpoczte...");
            }
            public void gvtRenderingCompleted(GVTTreeRendererEvent e) {
            	System.out.println("Rysowanie zakoczone.");
            }
        });
        canvas.setURI(url);
        
        JFrame f = new JFrame("Batik w akcji");
        f.getContentPane().add(canvas);
        f.pack();
        f.setVisible(true);
        f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

//        JFileChooser fc = new JFileChooser(".");
//        int choice = fc.showOpenDialog(f);
//        if (choice == JFileChooser.APPROVE_OPTION) {
//            File file = fc.getSelectedFile();
//            try {
//                canvas.setURI(file.toURL().toString());
//            } catch (IOException ex) {
//                ex.printStackTrace();
//            }
//        }

	}
}
