/*

Java. Programowanie, bibliteki open-source i pomysy na nowe projekty
Wydawnictwo Helion, 2006


 Example code from Wicked Cool Java (No Starch Press)
 Copyright (C) 2005 Brian D. Eubanks

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

 Note: The LGPL licence can be found online at http://www.gnu.org

 */

package com.wickedcooljava.sci;

import org.jgap.Chromosome;
import org.jgap.Configuration;
import org.jgap.Gene;
import org.jgap.Genotype;
import org.jgap.IChromosome;
import org.jgap.InvalidConfigurationException;
import org.jgap.impl.DefaultConfiguration;
import org.jgap.impl.IntegerGene;

import cern.colt.bitvector.BitVector;

/**
 * Demonstracja uycia algorytmw genetycznych w JGAP do stworzenia tablicy prawdy.
 */
public class DemuxFitness extends org.jgap.FitnessFunction {
	private SimpleTruthTable tt;

	public DemuxFitness() {
		// to jest nasz cel, do ktego chcemy wyewoluowa
		tt = new SimpleTruthTable(3, 4);
		tt.store(4, 1); // 100->0001
		tt.store(5, 2); // 101->0010
		tt.store(6, 4); // 110->0100
		tt.store(7, 8); // 111->1000
	}

	public int correctBits(int data) {
		BitVector vecValue = new BitVector(new long[] { data }, 32);
		BitVector target = tt.getTruthMatrix().toBitVector();
		// moemy znale liczb waciwych bitw za pomoc:
                // count(not(xor(target, vecValue)))
		vecValue.xor(target);
		vecValue.not();
		return vecValue.cardinality();
	}

	public double evaluate(IChromosome chrom) {
		int valueTotal = 0;
		for (int i = 7; i >= 0; i--) {
			IntegerGene gene = (IntegerGene) chrom.getGene(i);
			Integer value = (Integer) gene.getAllele();
			valueTotal += value;
			valueTotal <<= 4;
		}
		int correct = correctBits(valueTotal);
		// zwracamy kwadrat wartoci, aby bardziej podkreli dokadne odpowiedzi
		return correct * correct;
	}

	public static void main(String[] args) {
		Configuration config = new DefaultConfiguration();
		// osiem genw
		Gene[] genes = new Gene[8];
		try {
            for (int i = 0; i < 8; i++) {
                // liczba cakowita 4-bitowa (0-15 wcznie)
                genes[i] = new IntegerGene(config, 0, 15);
            }
            Chromosome sample = new Chromosome(config, genes);
			config.setSampleChromosome(sample);
			DemuxFitness fitTest = new DemuxFitness();
			config.setFitnessFunction(fitTest);
			config.setPopulationSize(200);
			Genotype population = Genotype.randomInitialGenotype(config);
			for (int i = 0; i < 1000; i++) {
				population.evolve();
			}
			IChromosome fittest = population.getFittestChromosome();
		} catch (InvalidConfigurationException e) {
			e.printStackTrace();
		}
	}
}