/*

Java. Programowanie, bibliteki open-source i pomysy na nowe projekty
Wydawnictwo Helion, 2006


Example code from Wicked Cool Java (No Starch Press)
Copyright (C) 2005 Brian D. Eubanks

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

Note: The LGPL licence can be found online at http://www.gnu.org

*/

package com.wickedcooljava.sci;

import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.TickerBehaviour;
import jade.lang.acl.ACLMessage;

/**
 * Testowa implementacja zachowania JADE.
 */
public class CheckQuoteBehaviour extends TickerBehaviour {
	Agent myAgent;
	
	public CheckQuoteBehaviour(Agent a) {
		super(a, 300 * 1000); // okres w milisekundach
		myAgent = a;
	}

	protected void onTick() {
		// pobierz aktualn cen
		if (getCurPrice() < 5.0) {
			// wylij wiadomo do agenta-kupca
			AID buyingAgent = new jade.core.AID("buyer", AID.ISLOCALNAME);
			// prosimy innego agenta o wykonanie pewnej czynnoci
			ACLMessage msg = new ACLMessage(ACLMessage.REQUEST);
			// wylij wiadomo (typu String)
			msg.setContent("kup 100 czegokolwiek");
			msg.addReceiver(buyingAgent);
			myAgent.send(msg);
		}
        // zatrzymaj po 1000 "tykni"
        if (getTickCount() > 1000) {
            stop();
        }
	}

	public double getCurPrice() {
		// w przypadku prawdziwego agenta ta warto byaby skd uzyskana
		return 12.00;
	}
}