/*

Java. Programowanie, bibliteki open-source i pomysy na nowe projekty
Wydawnictwo Helion, 2006


Example code from Wicked Cool Java (No Starch Press)
Copyright (C) 2005 Brian D. Eubanks

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

Note: The LGPL licence can be found online at http://www.gnu.org

*/

package com.wickedcooljava.web;

import java.net.URL;
import de.nava.informa.core.ChannelExporterIF;
import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.ItemIF;
import de.nava.informa.exporters.RSS_1_0_Exporter;
import de.nava.informa.impl.basic.ChannelBuilder;

/**
 * Tworzenie prostego kanau RSS
 */
public class SimpleRSSChannel {

	public static void main(String[] args) throws Exception {
		ChannelBuilder builder = new ChannelBuilder();
		ChannelIF myChannel = builder.createChannel("Ostatnie poprawki bdw");
		// To jest URL, dla ktrego opisujemy metadane
		URL channelURL = new URL("http://example.org/wcj/bugs.rss");
		myChannel.setLocation(channelURL);
		myChannel.setDescription("Najnowsze informacje o poprawkach bdw");
		
		// tworzymy pierwszy element
		String title = "Denerwujcy bd nr #25443 usunity";
		String desc = "Istotny bd w NaszejWspaniaejAplikacji zosta usunity. "
		  + "Bd #25443, dranicy uytkownikw ju od wersji 3.0, "
		  + "spowodowany by pustym wskanikiem.";
		URL url = new URL("http://example.org/wcj/bugfix25443.html");
		ItemIF anItem = builder.createItem(myChannel, title, desc, url);
		anItem.setCreator("Ecks Amples");
		
		//tworzymy drugi element
		title = "Bd #12121 nie poprawiony w NaszejWspaniaejAplikacji 7.1";
		desc = "Bd #12121 nie bdzie poprawiany w NaszejWspaniaejAplikacji " +
		  "wersji 7.1, aby programici mogli si skupi na NowejOdlotowej funkcji.";
		url = new URL("http://example.org/wcj/bugfix12121.html");
		anItem = builder.createItem(myChannel, title, desc, url);
		anItem.setCreator("Dee Veloper");

		// wyeksportuj dokument do pliku w formacie RSS 1.0
		ChannelExporterIF exporter = new RSS_1_0_Exporter("bugs.rss");
		exporter.write(myChannel);

	}
}
