/*

Java. Programowanie, bibliteki open-source i pomysy na nowe projekty
Wydawnictwo Helion, 2006


Example code from Wicked Cool Java (No Starch Press)
Copyright (C) 2005 Brian D. Eubanks

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

Note: The LGPL licence can be found online at http://www.gnu.org

*/

package com.wickedcooljava.sci;

import java.util.Set;

import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.ListenableDirectedGraph;

/**
 * Demo JGraphT API. 
 * Ta wersja zostaa zmodyfikowana w celu wsppracy z przykadem JGraph z 
 * rozdziau 6.
 */
public class HumanOrgansGraph {
	
	enum Organs {HEART, LUNG, LIVER, STOMACH, BRAIN, SPINAL_CORD};
	enum Systems {CIRCULATORY, DIGESTIVE, NERVOUS, RESPIRATORY};
	
	ListenableDirectedGraph<Enum, DefaultEdge> graph = null;
	
	/**
	 * Tworzy instancj uywajc danego grafu.
	 * @param g Graf ktry ma by uyty, lub null jeli ma by stworzony nowy.
	 */
	public HumanOrgansGraph(ListenableDirectedGraph<Enum, DefaultEdge> g)
	{
		if (g == null) {
			g = new ListenableDirectedGraph<Enum, DefaultEdge>(DefaultEdge.class);
		}	
		graph = g;
		// dodaj wierzchoki do grafu
		g.addVertex(Organs.HEART);
		g.addVertex(Organs.LUNG);
		g.addVertex(Organs.BRAIN);
		g.addVertex(Organs.STOMACH);
		g.addVertex(Organs.LIVER);
		g.addVertex(Organs.SPINAL_CORD);
		g.addVertex(Systems.CIRCULATORY);
		g.addVertex(Systems.NERVOUS);
		g.addVertex(Systems.DIGESTIVE);
		g.addVertex(Systems.RESPIRATORY);
		// pocz wierzchoki krawdziami
		g.addEdge(Organs.HEART, Systems.CIRCULATORY);
		g.addEdge(Organs.LUNG, Systems.RESPIRATORY);
		g.addEdge(Organs.BRAIN, Systems.NERVOUS);
		g.addEdge(Organs.SPINAL_CORD, Systems.NERVOUS);
		g.addEdge(Organs.STOMACH, Systems.DIGESTIVE);
		g.addEdge(Organs.LIVER, Systems.DIGESTIVE);
		
		// przejrzyj krawdzie poczone z wierzchokiem DIGESTIVE
		Set<DefaultEdge> digestiveLinks = g.edgesOf(Systems.DIGESTIVE);
		System.out.println("Organy ukadu pokarmowego w grafie - liczba " + digestiveLinks.size());
		for (DefaultEdge anEdge : digestiveLinks) {
		   Enum opposite = Graphs.getOppositeVertex(graph, anEdge, Systems.DIGESTIVE);
		   System.out.println(opposite);
		}
	}

	/**
	 * Dostp do grafu, w celu wykorzystania w rozdziale 6.
	 */
	public Graph getGraph()
	{
		return graph;
	}
	
	public static void main(String[] args) {
		new HumanOrgansGraph(null);
	}
}
