/*

Java. Programowanie, bibliteki open-source i pomysy na nowe projekty
Wydawnictwo Helion, 2006


Example code from Wicked Cool Java (No Starch Press)
Copyright (C) 2005 Brian D. Eubanks

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

Note: The LGPL licence can be found online at http://www.gnu.org

*/

package com.wickedcooljava.strings;

import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Scanner;

/**
 * Klasa ta pobiera dane ze statystyk spisu ludnoci USA, dostnych pod adresem http://www.census.gov/genealogy/names/
 * <BR />
 * Kod ten zakada, e pliki umieszczone s w katalogu C:\projects\census lub /projects/census
 */

public class CensusData
{

    List boys = null;
    List girls = null;
    List surnames = null;
    
    public static void main(String[] args)
    throws IOException
    {
        CensusData census = new CensusData();
        Random r = new Random();
        List boys = census.getBoyNames();
        List girls = census.getGirlNames();
        List surnames = census.getSurnames();
        System.out.println("Zaadowano " + boys.size() + " imion mskich");
        System.out.println("Zaadowano " + girls.size() + " imion eskich");
        System.out.println("Zaadowano " + surnames.size() + " nazwisk");
        
        System.out.print("Losowe imi mskie: ");
        String randomBoy = (String) boys.get(r.nextInt(boys.size()));
        System.out.println(randomBoy);
        System.out.print("Losowe imi eskie: ");
        String randomGirl = (String) girls.get(r.nextInt(girls.size()));
        System.out.println(randomGirl);
        System.out.print("Losowe nazwisko: ");
        String randomSurname = (String) surnames.get(r.nextInt(surnames.size())); 
        System.out.println(randomSurname);
    }
    
    public CensusData()
    throws IOException
    {
        // Java API automatycznie skonwertuje znaki / do \ pod Windows
        boys = readNameFile("C:/projects/census/dist.male.first");
        girls = readNameFile("C:/projects/census/dist.female.first");
        surnames = readNameFile("C:/projects/census/dist.all.last");
    }
    
    private List readNameFile(String fileName)
    throws IOException
    {
        ArrayList list = new ArrayList();
        FileReader fileReader = new FileReader(fileName);
        // utwrz skaner dla tego pliku
        Scanner scanner = new Scanner(fileReader);
        while (scanner.hasNext())
        {
            String name = scanner.next();
            float frequency = scanner.nextFloat();
            float cumulativeFrequency = scanner.nextFloat();
            int rank = scanner.nextInt();
            list.add(name);
        }
        scanner.close();        
        return list;
    }
    
    public List getBoyNames()
    {
        return boys;
    }
    
    public List getGirlNames()
    {
        return girls;
    }
    
    public List getSurnames()
    {
        return surnames;
    }
}
