/*

Java. Programowanie, bibliteki open-source i pomysy na nowe projekty
Wydawnictwo Helion, 2006


Example code from Wicked Cool Java (No Starch Press)
Copyright (C) 2005 Brian D. Eubanks

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

Note: The LGPL licence can be found online at http://www.gnu.org

*/

package com.wickedcooljava.sci;

import cern.colt.bitvector.BitMatrix;

/**
 * Prosta implementacja tabeli prawdy. 
 */
public class SimpleTruthTable {
	// macierz bitw 
	protected BitMatrix truthMatrix;
	// liczba bitw wejciowych
	private int inSize;
    // liczba bitw wyjciowych
	private int outSize;	

	/**
	 * Stwrz tabel prawdy o okrelonej licznie wej i wyj.
	 * Zainicjalizuj wyjcia na 0.
	 */
	public SimpleTruthTable(int inputs, int outputs) {
		inSize = inputs;
		outSize = outputs;
		int rows = 1 << inputs;
		int cols = outputs;
		truthMatrix = new BitMatrix(cols, rows);
	}

	/**
	 * Zwraca liczb bitw wejciowych.
	 */
	public int getInputSize() {
		return inSize;
	}

	/**
	 * Zwraca liczb bitw wyjciowych.
	 */
	public int getOutputSize() {
		return outSize;
	}
	
	/**
	 * Przechowuje mapowanie wej na wyjcia w tabeli prawdy.
	 * Dla wartoci wejcia <code>inputVal</code>, wyjcie powinno by <code>out</code>.
	 * Uwaga: warto wejciowa nie jest sprawdzana pod ktem rozmiaru wejcia.
	 */
	public void store(int inputVal, long out) {
		int start = inputVal * outSize;
		int end = start + outSize - 1; // wcznie
		truthMatrix.toBitVector().putLongFromTo(out, start, end);
	}
	
	/**
	 * Pobierz warto wyjciow z tabeli prawdy, dla danej wartoci wejciowej.
	 * Uwaga: warto wejciowa nie jest sprawdzana pod ktem rozmiaru wejcia.
	 */
	public long retrieve(int inputVal) {
		int start = inputVal * outSize;
		int end = start + outSize - 1; // wcznie
		long out = truthMatrix.toBitVector().getLongFromTo(start, end);
		return out;
	}
	
	/**
	 * Metoda pomocnicza dla uatwienia tworzenia tablic prawdy.
	 */
	public void setTruthMatrix(BitMatrix newMat) {
		if (newMat.rows() != truthMatrix.rows()
				|| newMat.columns() != truthMatrix.columns()) {
			throw new IndexOutOfBoundsException();
		}
		truthMatrix = newMat;
	}
	
	/**
	 * Dostp do tabeli przechowujcej bity.
	 */
	public BitMatrix getTruthMatrix() {
		return truthMatrix;
	}
}
