/*

Java. Programowanie, bibliteki open-source i pomysy na nowe projekty
Wydawnictwo Helion, 2006


Example code from Wicked Cool Java (No Starch Press)
Copyright (C) 2005 Brian D. Eubanks

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

Note: The LGPL licence can be found online at http://www.gnu.org

*/

package com.wickedcooljava.sci;

import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.ListenableDirectedGraph;

import com.wickedcooljava.sci.component.Component;
import com.wickedcooljava.sci.component.InputPort;
import com.wickedcooljava.sci.component.OutputPort;

/**
 * Prosta wersja klasy MetaComponent. Uywa grafu do przechowywania  
 * zalenoci midzy komponentami.
 */
public class MetaComponentSimple<T> {
	// graf, ktry przechowuje komponenty podrzdne
	private ListenableDirectedGraph<Object, DefaultEdge> graph;

	public MetaComponentSimple() {
		graph = new ListenableDirectedGraph<Object, DefaultEdge>(DefaultEdge.class);
	}

	/**
	 * czy port wyjciowy z wejciowym.
	 */
	public void connect(OutputPort<T> out, InputPort<T> in) {
		Component<T> source = out.getParent();
		Component<T> target = in.getParent();
		// dodaj komponenty nadrzdne do grafu
		if (!graph.containsVertex(source)) {
			graph.addVertex(source);
		}
		if (!graph.containsVertex(target)) {
			graph.addVertex(target);
		}
		// dodaj porty do grafu
		if (!graph.containsVertex(in)) {
			graph.addVertex(in);
		}
		if (!graph.containsVertex(out)) {
			graph.addVertex(out);
		}
		// dodaj krawd od komponentu-rda do portu wyjciowego
		graph.addEdge(source, out);
		// dodaj krawd od portu wyjciowego do wejciowego
		graph.addEdge(out, in);
		// dodaj krawd od portu wejciowego do komponentu-celu
		graph.addEdge(in, target);
	}

	/**
	 * Przetwarza kady z podrzdnych komponentw i przesya sygnay z wyj do wej.
	 */
	public void process() {
		processSubComponents();
		propagateSignals();
	}

	/**
	 * Przesya sygnay z wszystkich wyj na wejcia dla poczonych komponentw.
	 */
	private void propagateSignals() {
		for (DefaultEdge edge : graph.edgeSet()) {
			Object source = graph.getEdgeSource(edge);
			Object target = graph.getEdgeTarget(edge);
			if (source instanceof OutputPort) {
				OutputPort<T> out = (OutputPort<T>) source;
				InputPort<T> in = (InputPort<T>) target;
				in.setValue(out.getValue());
			}
		}
	}

	/**
	 * Wywouje metod process kadego z komponentw
	 */
	private void processSubComponents() {
		for (Object item : graph.vertexSet()) {
			if (item instanceof Component) {
				((Component<T>) item).process();
			}
		}
	}
	
	/**
	 * Zwraca graf uywany przez ten MetaComponent
	 */
	public Graph getGraph() {
		return graph;
	}

}