/*

Java. Programowanie, bibliteki open-source i pomysy na nowe projekty
Wydawnictwo Helion, 2006


Example code from Wicked Cool Java (No Starch Press)
Copyright (C) 2005 Brian D. Eubanks

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

Note: The LGPL licence can be found online at http://www.gnu.org

*/

package com.wickedcooljava.sci;

import org.joone.engine.Layer;
import org.joone.engine.Monitor;
import org.joone.io.FileOutputSynapse;
import org.joone.net.NeuralNet;
import org.joone.net.NeuralNetLoader;

/**
 * Kod pokazujcy jak uruchamia sieci neuronowe stworzone w edytorze Joone 
 * (poprzez menu File | Export NeuralNet).
 */
public class JooneExample {

	public static void main(String[] args) {
		NeuralNetLoader netLoader = new NeuralNetLoader(
				"/projects/nn/mynetwork.snet");
		NeuralNet myNet = netLoader.getNeuralNet();
		// pobierz warstw wyjciow sieci
		Layer output = myNet.getOutputLayer();
		// dodaj synaps wyjciow (poczenie) do warstwy wyjciowej
		FileOutputSynapse myOutput = new FileOutputSynapse();
		// ustaw plik wyjciowy na  mynetwork.out
		myOutput.setFileName("/projects/nn/mynetwork.out");
		output.addOutputSynapse(myOutput);
		Monitor monitor = myNet.getMonitor();
		// wykonaj jeden cykl
		monitor.setTotCicles(1);
		// ustaw flag fazy uczenia na 0
		monitor.setLearning(false);
		// uruchom warstwy sieci
		myNet.start();
		// uruchom monitor
		monitor.Go();
	}

}
