/*

Java. Programowanie, bibliteki open-source i pomysy na nowe projekty
Wydawnictwo Helion, 2006


Example code from Wicked Cool Java (No Starch Press)
Copyright (C) 2005 Brian D. Eubanks

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

Note: The LGPL licence can be found online at http://www.gnu.org

*/

package com.wickedcooljava.sci;

import javax.quantities.Duration;
import javax.quantities.Length;
import javax.quantities.Velocity;
import javax.units.NonSI;
import javax.units.SI;
import javax.units.Unit;
import javax.units.UnitFormat;

import org.jscience.physics.measures.Measure;

/**
 * Przykad tworzenia nowych jednostek w JScience i wywietlania wielkoci fizycznych z ich pomoc.
 */
public class FurlongFun {

	public static void main(String[] args) {
		// furlong to jedna sma mili
		Unit<Length> furlong = NonSI.MILE.times(0.125);
        UnitFormat.getStandardInstance().alias(furlong, "furlong");
        UnitFormat.getStandardInstance().label(furlong, "furlong");
        Measure<Velocity> c = Measure.valueOf(299792458, SI.METER_PER_SECOND);
		// fortnight to dawne okrelenie na 14 dni
		Unit<Duration> fortnight = NonSI.DAY.times(14);
        UnitFormat.getStandardInstance().alias(fortnight, "fortnight");
        UnitFormat.getStandardInstance().label(fortnight, "fortnight");
		Unit<Velocity> furlongperfortnight = (Unit<Velocity>) furlong.divide(fortnight);
		System.out.println(c.to(furlongperfortnight));
	}
}
