/*
 * Java. Programowanie, bibliteki open-source i pomysy na nowe projekty
 * Wydawnictwo Helion, 2006
 *
 *
 * Example code from Wicked Cool Java (No Starch Press) Copyright (C) 2005 Brian
 * D. Eubanks
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 * 
 * Note: The LGPL licence can be found online at http://www.gnu.org
 * 
 */

package com.wickedcooljava.misc;

import java.io.IOException;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.PostMethod;

/**
 * Uycie klasy HttpClient (Apache Commons) do przesania danych do strony internetowej
 * oraz pobrania odpowiedzi za pomoc metody POST.
 */
public class PostExample {

	public static void main(String[] args) {
		// wykonaj wyszukiwanie za pomoc metody POST
		HttpClient client = new HttpClient();
		String results = "";
		PostMethod method = new PostMethod("http://search.dmoz.org/cgi-bin/search");
		method.addParameter("search", "kawa");
		try {
			int respcode = client.executeMethod(method);
			if (respcode == HttpStatus.SC_OK) {
				results = method.getResponseBodyAsString();
			} else {
				System.err.println("Bd: " + method.getStatusLine());
			}
		} catch (HttpException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			method.releaseConnection();
		}
		System.out.println("--- Rezultaty ---");
		System.out.println(results);
	}
}
