/*

Java. Programowanie, bibliteki open-source i pomysy na nowe projekty
Wydawnictwo Helion, 2006


Example code from Wicked Cool Java (No Starch Press)
Copyright (C) 2005 Brian D. Eubanks

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

Note: The LGPL licence can be found online at http://www.gnu.org

*/

package com.wickedcooljava.sci;

import cern.colt.bitvector.BitVector;

/**
 * Najprostsze operacje na klasie BitVector z Colt.
 */
public class BasicBitVector {

	public static void main(String[] args) {
		BitVector vec1000 = new BitVector(1000); // rozmiar = 1000 bitw
		// pocztkowo wszystkie bity s ustawiane na false (0)
		vec1000.set(378); // ustaw bit 378 na true (1)
		System.out.println(vec1000.get(378)); // drukuje "true" na standardowym wyjciu
		vec1000.replaceFromToWith(1, 40, true); // ustawia bity od 1 do 40 na true
		// zwr bity z pozycji od 38 do 50 (wcznie)
		BitVector portion = vec1000.partFromTo(38, 50);
		//zwr warto typu long cigu bitw 3-10 
		long longValue = portion.getLongFromTo(3,10);
	}
}
