/*

Java. Programowanie, bibliteki open-source i pomysy na nowe projekty
Wydawnictwo Helion, 2006


Example code from Wicked Cool Java (No Starch Press)
Copyright (C) 2005 Brian D. Eubanks

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

Note: The LGPL licence can be found online at http://www.gnu.org

*/

package com.wickedcooljava.web;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.RDFS;

/**
 * Klasa ta tworzy przy uyciu API JENA prosty graf RDF opisujcy zalenoci firma-pracownik 
 */
public class SimpleCompanyGraph {

	public static void main(String[] args) {
		Model model = ModelFactory.createDefaultModel();
		model.setNsPrefix("wcj", "http://example.org/wcjava/");
		Resource employee = model.createResource("wcj:pracownik");
		Resource person = model.createResource("wcj:osoba");
		Resource employer = model.createResource("wcj:pracodawca");
		Resource organization = model.createResource("wcj:organizacja");
		Property hires = model.createProperty("wcj:zatrudnia");
		model.add(employer, hires, employee);
		model.add(employer, RDFS.subClassOf, organization);
		model.add(employee, RDFS.subClassOf, person);
		model.write(System.out, "N3");
	}
}
