/*

Java. Programowanie, bibliteki open-source i pomysy na nowe projekty
Wydawnictwo Helion, 2006


Example code from Wicked Cool Java (No Starch Press)
Copyright (C) 2005 Brian D. Eubanks

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

Note: The LGPL licence can be found online at http://www.gnu.org

*/

package com.wickedcooljava.web;

import java.io.IOException;

import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.ItemIF;
import de.nava.informa.core.ParseException;
import de.nava.informa.impl.basic.ChannelBuilder;
import de.nava.informa.parsers.FeedParser;
import de.nava.informa.utils.poller.Poller;
import de.nava.informa.utils.poller.PollerApproverIF;

/**
 * Przykad filtrowania wiadomoci RSS poprzez implementacj interfejsu PollerApproverIF.
 */
public class RelevancyApprover implements PollerApproverIF {

	public boolean canAddItem(ItemIF item, ChannelIF channel) {
		String title = item.getTitle();
		String description = item.getDescription();
		if (title.matches(".*Java.*") || description.matches(".*Java.*")) {
			return true;
		}
		else {
			return false;
		}
	}

	public static void main(String[] args) throws IOException, ParseException {
		ChannelBuilder builder = new ChannelBuilder();
		// wstaw odpowiedni adres
		String url = "http://example.org/wcj/bugs.rss";
		ChannelIF channel = FeedParser.parse(builder, url);
		channel.getItems().clear();
		System.out.println("Ilo elementw: " + channel.getItems().size());
		Poller poller = new Poller();
		poller.addApprover(new RelevancyApprover());
		poller.addObserver(new AnObserver());
		poller.registerChannel(channel);
	}
	
}
