// Określanie metody wysyłki przy użyciu klauzul case ze strzałką
class SwitchExprDemo2 {

  enum ShipMethod { STANDARD, TRUCK, AIR, OVERNIGHT }

  public static void main(String[] args) {

    int productID = 5099;

    // Zwróć uwagę, że w tym przykładzie wartości wyrażenia switch 
    // są określane przy użyciu klauzul case ze strzałką. Zauważ także,
    // że nie jest wymagane użycie instrukcji break,
    // zapobiegającej przekazywaniu sterowania do następnej klauzuli
    ShipMethod shipBy = switch(productID) {
      case 1774, 8708, 6709 -> ShipMethod.TRUCK;
      case 4657, 2195, 1887, 3621 -> ShipMethod.AIR;
      case 2907, 5099 -> ShipMethod.OVERNIGHT;
      default -> ShipMethod.STANDARD;
    };

    System.out.println("Produkt o ID " + productID + " jest wysyłany metodą " 
                       + shipBy);
  }
}
