/* Kopiuje plik tekstowy
   Uruchamiając ten program, podaj nazwę pliku
   źródłowego i pliku docelowego.
   Na przykład aby skopiować plik FIRST.TXT
   do pliku SECOND.TXT, użyj poniższego
   wywołania.

   java CopyFile FIRST.TXT SECOND.TXT
*/

import java.io.*;

class CopyFile {
  public static void main(String[] args) throws IOException 
  {
    int i;
    FileInputStream fin = null;
    FileOutputStream fout = null;

    // Upewnia się, że podano nazwy obu plików
    if(args.length != 2) {
      System.out.println("Sposób użycia: CopyFile Źródło Cel");
      return;
    }

    // Kopiuje plik
    try {
      // Próbuje otworzyć pliki
      fin = new FileInputStream(args[0]);
      fout = new FileOutputStream(args[1]);

      do {
        i = fin.read();
        if(i != -1) fout.write(i); 
      } while(i != -1);

    } catch(IOException exc) {
      System.out.println("Błąd wejścia-wyjścia: " + exc);
    } finally {
      try {
        if(fin != null) fin.close();
      } catch(IOException exc) {
        System.out.println("Błąd podczas zamykania pliku źródłowego.");
      }
      try {
        if(fout != null) fout.close();
      } catch(IOException exc) {
        System.out.println("Błąd podczas zamykania pliku docelowego.");
      }
    }
  }
}
