// Demonstruje typ surowy 
class Gen<T> {
  T ob; // Deklaruje obiekt typu T 
    
  // Konstruktor otrzymuje referencję
  // obiektu typu T 
  Gen(T o) { 
    ob = o; 
  }  
  
  // Zwraca obiekt ob 
  T getOb() {
    return ob; 
  }  
}  
  
// Demonstruje typ surowy 
class RawDemo {
  public static void main(String[] args) {
 
    // Tworzy obiekt klasy Gen dla typu Integer 
    Gen<Integer> iOb = new Gen<Integer>(88);
   
    // Tworzy obiekt klasy Gen dla typu String 
    Gen<String> strOb = new Gen<String>("Test typów sparametryzowanych"); 
  
    // Tworzy surowy obiekt klasy Gen 
    // i nadaje mu wartość typu Double 
    Gen raw = new Gen(98.6);  
 
    // Rzutowanie jest konieczne, ponieważ typ nie jest znany 
    double d = (Double) raw.getOb(); 
    System.out.println("wartość: " + d); 
 
    // Stosowanie typu surowego może prowadzić do wyjątków
    // podczas działania programu; oto kilka przykładów
 
    // Poniższe rzutowanie spowoduje błąd wykonania programu! 
//    int i = (Integer) raw.getOb(); // Błąd wykonania
 
    // Ta instrukcja przypisania narusza bezpieczeństwo typów 
    strOb = raw; // OK, ale potencjalne źródło błędu    
//    String str = strOb.getOb(); // Błąd wykonania 
     
    // Również ta instrukcja przypisania narusza bezpieczeństwo typów 
    raw = iOb; // OK, ale potencjalne źródło błędu
//    d = (Double) raw.getOb(); // Błąd wykonania 
  }  
}
