// Zapisuje, a następnie odczytuje dane binarne

import java.io.*;

class RWData {
  public static void main(String[] args)
  {
    int i = 10;
    double d = 1023.56;
    boolean b = true;

    // Zapisuje wartości
    try (DataOutputStream dataOut =
             new DataOutputStream(new FileOutputStream("testdata")))
    {
      System.out.println("Zapisuję " + i);
      dataOut.writeInt(i);

      System.out.println("Zapisuję " + d);
      dataOut.writeDouble(d);

      System.out.println("Zapisuję " + b);  
      dataOut.writeBoolean(b);

      System.out.println("Zapisuję " + 12.2 * 7.4);
      dataOut.writeDouble(12.2 * 7.4);
    }
    catch(IOException exc) {
      System.out.println("Błąd zapisu");
      return;
    }

    System.out.println();

    // Teraz odczytuje zapisane wartości
    try (DataInputStream dataIn = 
             new DataInputStream(new FileInputStream("testdata")))
    {
      i = dataIn.readInt();
      System.out.println("Odczytuję " + i);

      d = dataIn.readDouble();
      System.out.println("Odczytuję " + d);

      b = dataIn.readBoolean();
      System.out.println("Odczytuję " + b); 

      d = dataIn.readDouble();
      System.out.println("Odczytuję " + d);
    }
    catch(IOException exc) {
      System.out.println("Błąd odczytu");
    }
  }
}
