// Zastosowanie skróconego konstruktora rekordu Item
record Item(String name, int itemNum, double price) {

  public Item {
    // Usuwamy znaki odstępu z początku i końca nazwy poprzez
    // wywołanie metody trim() klasy String
    name = name.trim();

    // Po zakończeniu wykonywania konstruktora w polach
    // rekordu (name, itemNum oraz price) zostaną automatycznie zapisane
    // wartości odpowiadających im parametrów
  }
}

class RecordDemo2 { 
  public static void main(String[] args) { 
    // Tworzymy tablicę rekordów Item
    Item[] items = new Item[4];

    // Tworzymy listę produktów zapisanych jako rekordy Item.
    // Zwróć uwagę na sposób tworzenia poszczególnych rekordów.
    // Tutaj w nazwie nie ma żadnych znaków odstępu na początku lub końcu
    items[0] = new Item("Młotek", 257, 35.99);

    // Na początku lub końcu nazw tych produktów są znaki odstępu,
    // które zostaną usunięte przez skrócony konstruktor kanoniczny
    items[1] = new Item("   Klucz nastawny", 18, 64.15);
    items[2] = new Item("Wiertło   ", 903, 99.01);
    items[3] = new Item("   Piła   ", 27, 125.11);

    // Zastosowanie metod pobierających do wyświetlenia danych produktów
    for(Item i: items) {
      System.out.println("Produkt " + i.name() + " ma identyfikator " +
                          i.itemNum() + " i cenę " + i.price());
    }
  }
}
