// Zastosowanie sparametryzowanego interfejsu funkcyjnego. 
 
// Sprametryzowany interfejs funkcyjny, którego metoda ma 
// dwa parametry i zwraca wartość typu boolean.
interface SomeTest<T> { 
  boolean test(T n, T m); 
} 
 
class GenericFunctionalInterfaceDemo { 
  public static void main(String args[]) 
  { 
    // To wyrażenie lambda sprawdza, czy jedna liczba całkowita 
    // jest czynnikiem drugiej.
    SomeTest<Integer> isFactor = (n, d) -> (n % d) == 0; 
 
    if(isFactor.test(10, 2)) 
      System.out.println("Liczba 2 jest czynnikiem liczby 10"); 
    System.out.println(); 
 
    // Kolejne wyrażenie lambda sprawdza, czy jedna liczba 
    // typu Double jest czynnikiem drugiej. 
    SomeTest<Double> isFactorD = (n, d) -> (n % d) == 0; 
 
    if(isFactorD.test(212.0, 4.0)) 
      System.out.println("Liczba 4.0 jest czynnikiem liczby 212.0"); 
    System.out.println(); 
 
    // To wyrażenie lambda sprawdza czy, jeden łańcuch znakowy jest
    // fragmentem drugiego.
    SomeTest<String> isIn = (a, b) -> a.indexOf(b) != -1; 
 
    String str = "Sprametryzowany interfejs funkcyjny"; 
 
    System.out.println("Sprawdzamy łańcuch znakowy: " + str); 
 
    if(isIn.test(str, "fejs")) 
      System.out.println("Łańcuch 'fejs' został znaleziony."); 
    else 
      System.out.println("Łańcuch 'fejs' nie został znaleziony."); 
  } 
}
