// Prosty przykład klasy sparametryzowanej.  
// T jest parametrem oznaczającym typ 
// i zostanie zastąpiony rzeczywistym typem 
// podczas tworzenia obiektu typu Gen. 
class Gen<T> { 
  T ob; // deklaruje obiekt typu T 
   
  // Konstruktor otrzymuje referencję  
  // obiektu typu T. 
  Gen(T o) { 
    ob = o; 
  } 
 
  // Zwraca ob. 
  T getob() { 
    return ob; 
  } 
 
  // Wyświetla typ T. 
  void showType() { 
    System.out.println("Typem T jest " + 
                       ob.getClass().getName()); 
  } 
} 
 
// Demonstruje użycie klasy sparametryzowanej. 
class GenDemo { 
  public static void main(String args[]) { 
    // Tworzy referencję typu Gen, którego parametrem
    // jest typ Integer.  
    Gen<Integer> iOb;  
 
    // Tworzy obiekt Gen<Integer> i przypisuje jego referencję 
    // zmiennej iOb.  Zwróć uwagę na zastosowanie automatycznego  
    // opakowania wartości 88 obiektem Integer. 
    iOb = new Gen<Integer>(88); 
 
    // Wyświetla typ danych używany przez iOb. 
    iOb.showType(); 
 
    // Pobiera wartość iOb. Zwróć uwagę, że rzutowaniwe nie jest 
    // potrzebne w tym przypadku. 
    int v = iOb.getob(); 
    System.out.println("wartość: " + v); 
 
    System.out.println(); 
 
    // Tworzy obiekt Gen wykorzystujący typ String. 
    Gen<String> strOb = new Gen<String>("Test typów sparametryzowanych"); 
 
    // Wyświetla typ danych używany przez strOb. 
    strOb.showType(); 
 
    // Pobiera wartość iOb. Zwróć uwagę, że znowu rzutowaniwe 
    // nie jest potrzebne. 
    String str = strOb.getob(); 
    System.out.println("wartość: " + str); 
  } 
}
