// W tej wersji klasyNumericFns, typ przekazywany 
// jako parametr T musi być albo klasą Number 
// albo jej klasą pochodną. 
class NumericFns<T extends Number> {  
  T num; 
    
  // Przekazuje konstruktorowi referencję
  // obiektu numerycznego.
  NumericFns(T n) {  
    num = n; 
  }  
  
  // Zwraca odwrotność. 
  double reciprocal() { 
    return 1 / num.doubleValue(); 
  } 
 
  // Zwraca część ułamkową. 
  double fraction() { 
    return num.doubleValue() - num.intValue(); 
  } 
 
  // ... 
}  
  
// Demonstruje użycie klasy NumericFns.  
class BoundsDemo {  
  public static void main(String args[]) {  
 
    NumericFns<Integer> iOb = 
                      new NumericFns<Integer>(5);   
 
    System.out.println("Odwrotność iOb wynosi " + 
                        iOb.reciprocal()); 
    System.out.println("Część dziesiętna iOb wynosi " + 
                        iOb.fraction()); 
 
    System.out.println(); 
 
    NumericFns<Double> dOb = 
                      new NumericFns<Double>(5.25);   
 
    System.out.println("Odwrotność dOb wynosi " + 
                        dOb.reciprocal()); 
    System.out.println("Część dziesiętna dOb wynosi " + 
                        dOb.fraction()); 
 
 
    // Ta instrukcja nie zostanie skompilowana, ponieważ String
    // nie jest klasą pochodną klasy Number. 
//    NumericFns<String> strOb = new NumericFns<String>("Błąd");   
  }  
}
