// Używa metod wait() and notify() 
// do stworzenia symulacji zegara. 
 
class TickTock { 

  String state; // przechowuje stan zegara
 
  synchronized void tick(boolean running) { 
    if(!running) { // zatrzmuje zegar 
      state = "ticked";
      notify(); // powiadamia oczekujący wątek 
      return; 
    } 
 
    System.out.print("tik "); 

    state = "ticked"; // zmienia stan zegara na "ticked"

    notify(); // umożliwia wykonanie metody tock() 
    try { 
      while(!state.equals("tocked"))
        wait(); // oczekuje na zakończenie metody tock()
    } 
    catch(InterruptedException exc) { 
      System.out.println("Wątek został przerwany."); 
    } 
  } 
 
  synchronized void tock(boolean running) { 
    if(!running) { // zatrzymuje zegar 
      state = "tocked";
      notify(); // powiadamia oczekujący wątek 
      return; 
    } 
 
    System.out.println("tak"); 

    state = "tocked"; // zmienia stan zegara na "tocked"

    notify(); // umożliwia wykonanie metody tick() 
    try { 
      while(!state.equals("ticked"))
        wait(); // oczekuje na zakończenie metody tick()
    } 
    catch(InterruptedException exc) { 
      System.out.println("Wątek został przerwany."); 
    } 
  } 
}  
 
class MyThread implements Runnable { 
  Thread thrd; 
  TickTock ttOb; 
 
  // Tworzy nowy wątek. 
  MyThread(String name, TickTock tt) { 
    thrd = new Thread(this, name); 
    ttOb = tt; 
  } 
 
  // Metoda wytwórcza, która tworzy i uruchamia wątek.
  public static MyThread createAndStart(String name, TickTock tt) {
    MyThread myThrd = new MyThread(name, tt);
    
    myThrd.thrd.start(); // uruchamia nowy wątek
    return myThrd;
  }

  // Rozpoczyna wykonywanie nowego wątku. 
  public void run() { 
 
    if(thrd.getName().compareTo("tik") == 0) { 
      for(int i=0; i<5; i++) ttOb.tick(true); 
      ttOb.tick(false); 
    } 
    else { 
      for(int i=0; i<5; i++) ttOb.tock(true); 
      ttOb.tock(false); 
    } 
  } 
} 
 
class ThreadCom { 
  public static void main(String args[]) { 
    TickTock tt = new TickTock(); 
    MyThread mt1 = MyThread.createAndStart("tik", tt); 
    MyThread mt2 = MyThread.createAndStart("tak", tt); 
 
    try { 
      mt1.thrd.join(); 
      mt2.thrd.join(); 
    } catch(InterruptedException exc) { 
      System.out.println("Wątek główny został przerwany."); 
    } 
  } 
}
