// Klasa TickTock odmierzająca czas rzeczywisty.
 
class TickTock { 

  String state; // przechowuje stan zegara
 
  synchronized void tick(boolean running) { 
    if(!running) { // zatrzymuje zegar 
      state = "ticked";
      notify(); // powiadamia oczekujący wątek 
      return; 
    } 
 
    System.out.print("Tick "); 

    // czeka pół sekundy
    try {
      Thread.sleep(500);
    } catch(InterruptedException exc) {
      System.out.println("Wątek został przerwany.");
    }

    state = "ticked"; // zmienia stan zegara na "ticked"

    notify(); // umożliwia wykonanie metody tock() 
    try { 
      while(!state.equals("tocked"))
        wait(); // oczekuje na zakończenie metody tock()
    } 
    catch(InterruptedException exc) { 
      System.out.println("Wątek został przerwany."); 
    } 
  } 
 
  synchronized void tock(boolean running) { 
    if(!running) { // zatrzymuje zegar 
      state = "tocked";
      notify(); // powiadamia oczekujący wątek 
      return; 
    } 
 
    System.out.println("Tock"); 

    // czeka pół sekundy
    try {
      Thread.sleep(500);
    } catch(InterruptedException exc) {
      System.out.println("Wątek został przerwany.");
    }

    state = "tocked"; // zmienia stan zegara na "tocked"

    notify(); // umożliwia wykonanie metody tick() 
    try { 
      while(!state.equals("ticked"))
        wait(); // oczekuje na zakończenie metody tick()
    } 
    catch(InterruptedException exc) { 
      System.out.println("Wątek został przerwany."); 
    } 
  } 
}
