// Prezentacja stosowania pól tekstowych. 
 
import javafx.application.*; 
import javafx.scene.*; 
import javafx.stage.*; 
import javafx.scene.layout.*; 
import javafx.scene.control.*; 
import javafx.event.*; 
import javafx.geometry.*; 
 
public class TextFieldDemo extends Application { 
 
  TextField tf; 
  Label response; 
 
  public static void main(String[] args) { 
 
    // Uruchamia aplikację JavaFX, wywołując metodę launch(). 
    launch(args);   
  } 
 
  // Przesłonięcie metody start(). 
  public void start(Stage myStage) { 
 
    // Określa tytuł obszaru roboczego. 
    myStage.setTitle("Prezentacja pola tekstowego"); 
 
    // Jako korzeń zostaje użyty panel FlowPane. W tym 
    // przypadku pionowe i poziome odstępy pomiędzy umieszczonymi
    // w nim kontrolkami będą wynosić 10. 
    FlowPane rootNode = new FlowPane(10, 10); 
 
    // Wyrównuje kontrolki do środka.
    rootNode.setAlignment(Pos.CENTER); 
 
    // Tworzy obiekt Scene. 
    Scene myScene = new Scene(rootNode, 230, 140); 
 
    // Dodaje obiekt Scene do obiektu Stage. 
    myStage.setScene(myScene); 
 
    // Tworzy etykietę pola tekstowego.
    response = new Label("Jak masz na imię: "); 
 
    // Tworzy przycisk do pobierania tekstu.
    Button btnGetText = new Button("Pobierz imię"); 
 
    // Tworzy pole tekstowe.
    tf = new TextField(); 
 
    // Określa komunikat informacyjny.
    tf.setPromptText("Wpisz imię."); 
 
    // Podaje preferowaną liczbę kolumn — wielkość pola.
    tf.setPrefColumnCount(15); 
 
    // Używamy wyrażenia lambda do obsługi zdarzeń action
    // generowanych przez pole tekstowe. Zdarzenia te są 
    // generowane, gdy użytkownik naciśnie klawisz ENTER
    // podczas wpisywania tekstu w polu. W tym przypadku obsługa
    // zdarzenia sprowadza się do pobrania i wyświetlenia 
    // wpisanego imienia.
    tf.setOnAction( (ae) -> response.setText("Naciśnięto ENTER. " + 
                                "Wpisane imię to: " + tf.getText())); 
 
    // Wyrażenia lambda używamy także do pobrania i wyświetlenia 
    // imienia po kliknięciu przycisku.
    btnGetText.setOnAction((ae) -> 
                            response.setText("Kliknięto przycisk. " + 
                                "Wpisane imię to: " + tf.getText())); 
 
    // Używa separatora, aby ładniej rozmieścić elementy 
    // w układzie.
    Separator separator = new Separator(); 
    separator.setPrefWidth(180); 
 
    // Dodaje etykietę i kontrolkę listy do grafu sceny.
    rootNode.getChildren().addAll(tf, btnGetText, separator, response); 
 
    // Wyświetla scenę i obszar roboczy. 
    myStage.show(); 
  } 
}
