// Używa join().

class MyThread implements Runnable {
  Thread thrd;

  // Tworzy nowy wątek.
  MyThread(String name) {
    thrd = new Thread(this, name);
  }

  // Metoda wytwórcza, która tworzy i uruchamia wątek.
  public static MyThread createAndStart(String name) {
    MyThread myThrd = new MyThread(name);
    
    myThrd.thrd.start(); // uruchamia nowy wątek
    return myThrd;
  }

  // Rozpoczyna wykonywanie nowego wątku.
  public void run() {
    System.out.println(thrd.getName() + " rozpoczyna działanie.");
    try {
      for(int count=0; count < 10; count++) {
        Thread.sleep(400);
        System.out.println(thrd.getName() +
                           " jest wykonywany, wartość licznika: " + count);
      }
    }
    catch(InterruptedException exc) {
      System.out.println(thrd.getName() + " został przerwany.");
    }
    System.out.println(thrd.getName() + " kończy działanie.");
  }
}

class JoinThreads {
  public static void main(String args[]) {
    System.out.println("Główny wątek rozpoczyna działanie."); 

    MyThread mt1 = MyThread.createAndStart("Wątek potomny nr 1"); 
    MyThread mt2 = MyThread.createAndStart("Wątek potomny nr 2"); 
    MyThread mt3 = MyThread.createAndStart("Wątek potomny nr 3"); 

    try {
      mt1.thrd.join();
      System.out.println("Wątek potomny nr 1 zakończył działanie.");
      mt2.thrd.join();
      System.out.println("Wątek potomny nr 2 zakończył działanie.");
      mt3.thrd.join();
      System.out.println("Wątek potomny nr 3 zakończył działanie.");
    }
    catch(InterruptedException exc) {
      System.out.println("Wątek główny został przerwany."); 
    }
    System.out.println("Wątek główny kończy działanie."); 
  }
}